//  Misja w nadprzestrzeń C++14/17, program z paragrafu 1.4

#include <iostream>
#include <string>
#include <vector>
using namespace std;
//******************************************************
// szablon funkcji 	[czarna_litera_wielka]  A
template <bool ... pakiet_wartosci_bool>			// <-pakiet wartości typu bool  			// `1
string   zaslon_wg_wzoru(string tekst)											// `2
{
	constexpr unsigned int rozmiar_tablicy = sizeof...(pakiet_wartosci_bool);			// `3

	if constexpr (rozmiar_tablicy > 0) 	 										// `4
	{
		// przepisanie wartości do tablicy
		bool  wzorek[rozmiar_tablicy]  { pakiet_wartosci_bool...};		 			// `5

		for(unsigned int i = 0 ; i < tekst.size() ; ++i  )							// `6
		{
			if(wzorek[i% rozmiar_tablicy] == false) 							// `7
			{
				tekst[i] = '*';													// `8
			}
		}
	}
	return tekst; 															// `9
}
/////////////////////////////////////////////////////////////////////////////////////////
// szablon klasy		[czarna_litera_wielka]  B
 template <char ... wartosci>												// `10
struct Tzaslaniacz_liter
{
	char  tablica_trefnych_znakow[sizeof...(wartosci)+1] = { wartosci...};  			// `11

	// funkcja składowa
	string   zaslon_wg_liter(string tekst) 										// `12
	{
		while(true)														// `13
		{
			string::size_type gdzie = tekst.find_first_of(tablica_trefnych_znakow, 0 );		// `14
			if (gdzie != string::npos)
				tekst[gdzie] = '*'; 											// `15
			else
				return tekst; // gdy nie ma więcej wybranych znaków  			// `16
		}
	}
};
//******************************************************
int main()
{
	cout << "Zaslanianie wg ustalonego wzorku/rytmu--------------\n";

	string rezultat;
	rezultat =
		zaslon_wg_wzoru<true, false, false, false>("Na wiosne tatus wywozi gnoj na pole");		// `17
	cout << rezultat << endl;

	cout <<  zaslon_wg_wzoru<true, false, false, true, false>("i rozrzuca go razem z mamusia")	// `18
		<< endl;

	cout << "W przypadku pustego wzoru" << endl;
	rezultat = zaslon_wg_wzoru< >("Gdy pusty wzorek, co wtedy?");				// `19
	cout << rezultat << endl;

	cout << "\nZaslanianie wg ustalonych liter--------------------\n";

	Tzaslaniacz_liter<'a','e'>   koderAE;										// `20
	rezultat = koderAE.zaslon_wg_liter("Straszne byly te krzyzackie mordy"); 			// `21
	cout << rezultat << endl;

	cout << koderAE.zaslon_wg_liter("abcdefghijklmnopqrstuvxyz\n");				// `22

	Tzaslaniacz_liter< >   koderPusty; 										// `23
	cout << koderPusty.zaslon_wg_liter("Mieczow ci u nas dostatek, ale i te przyjmiemy\n");
}
