//  Misja w nadprzestrzeń C++14/17, program z paragrafu 1.2

#include <iostream>
#include <string>
using namespace std;
//******************************************************
void demo()		// ta deklaracja powinna być koniecznie powyżej definicji szablonu
{
	cout << "To wywolanie  demo()  bez ZADNYCH argumentow, nie bedzie dalszych wywolan"
		<< endl;  															// `1
}
//******************************************************
template <typename T, typename...   Tpakiet>									// `2
void demo(T pierwszy, Tpakiet... reszta)										// `3
{
	cout	<< "To wywolanie\n  " << __PRETTY_FUNCTION__
		<< "\n  demo(argumentow: "
		<< (1+ sizeof...( Tpakiet))											// `4
		<< ")" << endl;

	// na pierwszym argumencie wykonujemy żądaną operację
	cout << "  wypisanie pierwszego ["
		<< pierwszy   													 // `5
		<< "], (po nim pakiet "
		<< sizeof...( reszta)  												// `6
		<< " dalszych argumentow)"
		<< endl;
	// pozostałe argumenty wysyłamy do funkcji szablonowej o n-1 argumentach
	demo(reszta...);		// <--- wywołanie niby-rekurencyjne	 				 // `7
}
//******************************************************
// void wydrukuj() {}														 // `8
//******************************************************
template <typename T, typename...   Tpakiet>									// `9
void wydrukuj(T pierwszy, Tpakiet... reszta)
{
	// coś robimy z pierwszym argumentem, bo mamy do niego dostęp
	cout << pierwszy << " ";

	if constexpr(sizeof...(Tpakiet) > 0)											// `10
	{
		wydrukuj(reszta...);		// <---wywołanie niby-rekurencyjne
	}
}
//******************************************************
int main()
{
	demo(100, '$', 3.14); 													// `11

	cout << "\nMniej gadatliwa wersja robiaca prawie to samo\n";
	wydrukuj(100, '$', 3.14);  												// `12

	cout << "\nDowod, ze mozemy obsluzyc nawet bardzo wiele argumentow\n";
	wydrukuj(1, "alert", 3.33, '#', 100, "silniki jonowe", 3, "przegrzanie", string("ASDFG") );		  // `13
}
