/*
Odkrywanie świata Arduino, Wydanie drugie
Listing 16.3: Lampka reagująca na zbliżenie
https://www.exploringarduino.com/content2/ch16

Wszelkie prawa zastrzeżone 2019 Jeremy Blum ( https://www.jeremyblum.com )
Licencja MIT ( https://github.com/sciguy14/Exploring-Arduino-2nd-Edition/blob/master/LICENSE.md )
*/

// Automatyczne włączenie/wyłączenie lampy, gdy smartfon się łączy lub rozłącza

// Dołączenie biblioteki nRF51 SPI
#include "Adafruit_BluefruitLE_SPI.h"

// Czip nRF51 jest podłączony do pinów SPI mikrokontrolera 32U4. 
// Kiedy tworzymy obiekt BTLE, musimy podać ich numery: CS (8), IRQ (7) i RST (4):

Adafruit_BluefruitLE_SPI btle(8, 7, 4);

// Taka będzie nazwa urządzenie BTLE na Twoim smartfonie
const String BTLE_NAME = "Smart Lamp";

// Ustawienie poziomu mocy mające wpływ na odległość aktywacji połączenia
// Możliwe wartości to: -40, -20, -16, -12, -8, -4, 0, 4
// Im większa liczba, tym większy zakres
const int POWER_LEVEL = -20;

// Pin sterujący lampą
const int LAMP_PIN = 5;

void setup(void)
{
  // Ustawienie sterującego lampą jako wyjście i ustawienie stanu na niski
  pinMode(LAMP_PIN, OUTPUT);
  digitalWrite(LAMP_PIN, LOW);

  // Będziemy wyświetlać informacje w monitorze portu szeregowego na potrzeby debugowania.
  Serial.begin(9600);

  // 32U4 ma sprzętowy interfejs USB, więc poniższe linijki nie powinny być oznaczone jako komentarz, 
  // jeśli chcesz, aby uruchomił się dopiero po otwarciu monitora portu szeregowego. 
  // Oznacz poniższą linijkę jako komentarz, jeśli chcesz uruchomić szkic bez otwierania konsoli szeregowej.
  //while (!Serial);


  // Połączenie z modułem
  Serial.print(F("Inicjalizacja BTLE..."));
  if (!btle.begin())
  {
    Serial.println("");
    Serial.println(F("Nieudana próba połączenia z chipem nRF51."));
    while (1);
  }
  Serial.println(F("Gotowe!"));

  // Przywrócenie ustawień domyślnych
  Serial.print(F("Przywracanie ustawień domyślnych..."));
  if (!btle.factoryReset())
  {
    Serial.println("");
    Serial.println(F("Nie udało się przywrócić ustawień domyślnych."));
    while (1);
  }
  Serial.println(F("Gotowe!"));

   // Ustawienie nazwy za pomocą polecenia AT
  Serial.print(F("Nadawanie urządzeniu nazwy ..."));
  btle.print(F("AT+GAPDEVNAME="));
  btle.println(BTLE_NAME);
  if (!btle.waitForOK())
  {
    Serial.println(F("Nadanie nazwy nieudane."));
    while (1);
  }
  Serial.println(F("Gotowe!"));

  // Ustawienie poziomu mocy
  Serial.print(F("Ustawienie poziomu mocy..."));
  btle.print(F("AT+BLEPOWERLEVEL="));
  btle.println(String(POWER_LEVEL));
  if (!btle.waitForOK())
  {
    Serial.println(F("Ustawienie poziomu mocy."));
    while (1);
  }
  Serial.println(F("Gotowe!"));

  // Aktywacja profilu klawiatury HID
// (Konieczne w przypadku systemu iOS, aby urządzenie zostało rozpoznane bez użycia specjalnej aplikacji)
  Serial.print(F("Aktywacja klawiatury HID..."));
  btle.println(F("AT+BLEKEYBOARDEN=1"));
  if (!btle.waitForOK())
  {
    Serial.println(F("Nieudana aktywacja profilu klawiatury HID."));
    while (1);
  }
  Serial.println(F("Gotowe!"));

  btle.reset(); // Restart modułu, aby zmiana ustawień weszła w życie
}

void loop(void)
{
  if (btle.isConnected())
  {
    // Włącz lampkę, gdy smartfon jest połączony
    digitalWrite(LAMP_PIN, HIGH);
  }
  if (!btle.isConnected())
  {
    // Wyłącz lampkę, gdy smartfon jest rozłączony
    digitalWrite(LAMP_PIN, LOW);
  }
}
