/*
Odkrywanie świata Arduino, Wydanie drugie
Listing 16.2: BTLE LED
https://www.exploringarduino.com/content2/ch16

Wszelkie prawa zastrzeżone 2019 Jeremy Blum ( https://www.jeremyblum.com )
Licencja MIT ( https://github.com/sciguy14/Exploring-Arduino-2nd-Edition/blob/master/LICENSE.md )
*/

// Sterowanie diodą LED przez BTLE

// Dołączenie biblioteki nRF51 SPI
#include "Adafruit_BluefruitLE_SPI.h"

// Czip nRF51 jest podłączony do pinów SPI mikrokontrolera 32U4. 
// Kiedy tworzymy obiekt BTLE, musimy podać ich numery: CS (8), IRQ (7) i RST (4):

Adafruit_BluefruitLE_SPI btle(8, 7, 4);

// Ustawienie zmiennej na true w celu jednorazowej konfiguracji
// Dzięki temu nastąpi reset  i zmieni się nazwa połączenia.
// Nic się nie stanie jeżeli będzie to wykonywane przy każdym uruchomieniu (pozostaw wartość true).
// Możesz zmienić na false przy kolejnych wgrywaniach programu do modułu.
const bool PERFORM_CONFIGURATION = true; 

// Taka będzie nazwa urządzenie BTLE na Twoim smartfonie
const String BTLE_NAME = "Jeremy's LED";

// Znajdująca się na płytce dioda LED jest podłączona do pinu 13
const int STATUS_LED = 13;

// Dioda LED jest podłączona do pinu 5
const int CTRL_LED = 5;

// Zmienne przechowujące stan diody LED
bool led_state = LOW;
String cmd = "";
String reply = "";

void setup(void)
{
  // Ustawienie pinu diody LED jako wyjście i wyłączenie jej
  pinMode(STATUS_LED, OUTPUT);
  digitalWrite(STATUS_LED, LOW);
  pinMode(CTRL_LED, OUTPUT);
  digitalWrite(CTRL_LED, led_state);
  
  // Będziemy wyświetlać informacje w monitorze portu szeregowego na potrzeby debugowania.
  Serial.begin(9600);
  
  // 32U4 ma sprzętowy interfejs USB, więc poniższe linijki nie powinny być oznaczone jako komentarz, 
  // jeśli chcesz, aby uruchomił się dopiero po otwarciu monitora portu szeregowego. 
  // Oznacz poniższą linijkę jako komentarz, jeśli chcesz uruchomić szkic bez otwierania konsoli szeregowej.

  while(!Serial);

  // Połączenie z modułem
  Serial.print(F("Inicjalizacja BTLE..."));
  if (!btle.begin())
  {
    Serial.println("");
    Serial.println(F("Nieudana próba połączenia z chipem nRF51."));
    while(1);
  }
  Serial.println(F("Gotowe!"));

  // Przywróć ustawienia fabryczne czipa BTLE.
  // Możesz zastosować reset w przypadku jakichkolwiek błędów w programie powodujących, że moduł nie odpowiada.
  // Po przywróceniu ustawień fabrycznych modułu nadawana jest nazwa.

  if (PERFORM_CONFIGURATION)
  {
    // Przywróć ustawienia domyślne
    Serial.print(F("Przywracanie ustawień domyślnych..."));
    if (!btle.factoryReset())
    {
      Serial.println("");
      Serial.println(F("Nie udało się przywrócić ustawień domyślnych."));
      while(1);
    }
    Serial.println(F("Gotowe!"));

    // Ustawienie nazwy za pomocą polecenia AT
    Serial.print(F("Nadawanie urządzeniu nazwy ..."));
    btle.print(F("AT+GAPDEVNAME="));
    btle.println(BTLE_NAME);
    if (!btle.waitForOK())
    {
      Serial.println(F("Nadanie nazwy nieudane."));
      while(1);
    }
    btle.reset(); // Restart modułu, aby nowa nazwa weszła w życie
    Serial.println(F("Gotowe!"));
  }
  
  // Przełączenie na tryb danych (z trybu poleceń)
  btle.setMode(BLUEFRUIT_MODE_DATA);
}

void loop(void)
{
// Poczekaj na połączenie ze smartfonem (jeśli jeszcze nie jest połączony)
  if (!btle.isConnected())
  {
    Serial.print("Czekam na połączenie ze smartfonem...");
    while (!btle.isConnected())
    {
        delay(1000);
    }
    Serial.println("Połączono!");
  }

  // Jeśli dostępne są przychodzące dane, przeczytaj je i przeanalizuj
  while (btle.available() > 0)
  {
    // Gdy otrzymasz żądanie, zapal na chwilę informującą o stanie diodę LED.
    digitalWrite(STATUS_LED, HIGH);
    
    // Czytaj z bufora, aż na napotkasz znak nowej linii.
    cmd = btle.readStringUntil('\n');
      
    Serial.print(F("Otrzymane polecenie: "));
    Serial.println(cmd);
    
    // Zamiana wszystkich liter polecenia na małe w celu jego rozpoznania bez względu na wielkość liter
    cmd.toLowerCase();

    // Sprawdź czy w poleceniu znajduje się słowo "czerwoną" lub "led"
    if (cmd.indexOf(F("czerwoną")) != -1 || cmd.indexOf(F("led")) != -1)
    {
      // Czy w poleceniu jest słowo "włącz"?
      if (cmd.indexOf(F("włącz")) != -1)
      {
        led_state = HIGH; 
        reply = F("OK! Dioda LED została włączona.");
      }
      
      // Czy w poleceniu jest słowo "wyłącz"?
      else if (cmd.indexOf(F("wyłącz")) != -1)
      {
        led_state = LOW;
        reply = F("OK! Dioda LED została wyłączona.");
      }

      // Czy w poleceniu jest słowo "zmień"?
      else if (cmd.indexOf(F("zmień")) != -1)
      {
        led_state = !led_state;
        if (led_state) reply = F("OK! Stan diody LED został zmieniony na włączony.");
        else reply = F("OK! Stan diody LED został zmieniony na wyłączony.");
      }

      // Polecenie zawiera słowa "czerwoną" lub "led", ale nie ma pozostałych słów kluczowych.
      else 
      {
        if (led_state) reply = F("Dioda LED jest włączona.");
        else reply = F("Dioda LED jest wyłączona.");
      }

      // Ustaw stan diody
      digitalWrite(CTRL_LED, led_state);
    }
    else
    {
      reply = F("Polecenie nierozpoznane.");
    }

    // Potwierdź przyjęcie polecenia
    btle.println(reply);
    Serial.print(F("Odpowiedź: "));
    Serial.println(reply);
    btle.waitForOK();
    digitalWrite(STATUS_LED, LOW);
  }
}
