/*
Odkrywanie świata Arduino, Wydanie drugie
Listing 15.2: Dzwonek do drzwi
https://www.exploringarduino.com/content2/ch15

Wszelkie prawa zastrzeżone 2019 Jeremy Blum ( https://www.jeremyblum.com )
Licencja MIT ( https://github.com/sciguy14/Exploring-Arduino-2nd-Edition/blob/master/LICENSE.md )
*/

//Dzwonek do drzwi wykorzystujący prostu odbiornik radiowy

//Program zakłada, że używany jest typ chwilowy modułu odbiornika!
//Typ chwilowy M4 działa tak samo jak przełącznik chwilowy.
//Gdy przycisk jest wciśnięty, pin D2 ma stan wysoki.
//Gdy przycisk nie jest wciśnięty, pin D2 ma stan niski.

#include "pitches.h" //Plik nagłówkowy z definicją dźwięków

//Pin wejścia/wyjścia Arudino jest podłączony do modułu, do pinu oznaczonego jako D2 
const int TRIGGER_PIN = 13;
const int SPEAKER = 9;  //Pin głośnika

//Tablica dźwięków
int notes[] = {
 NOTE_A4, NOTE_E3, NOTE_A4, 0, 
 NOTE_A4, NOTE_E3, NOTE_A4, 0,
 NOTE_E4, NOTE_D4, NOTE_C4, NOTE_B4, NOTE_A4, NOTE_B4, NOTE_C4, NOTE_D4,
 NOTE_E4, NOTE_E3, NOTE_A4, 0
};

//Długość każdej nuty (w milisekundach)
int times[] = {
 250, 250, 250, 250, 
 250, 250, 250, 250,
 125, 125, 125, 125, 125, 125, 125, 125,
 250, 250, 250, 250 
};

void setup()
{
//Nie jest wymagana żadna konfiguracja
}

void loop()
{
  //Gdy przycisk jest wciśnięty, zagraj melodię tylko raz.
  if (digitalRead(TRIGGER_PIN))
  {
    for (int i = 0; i < 20; i++)
    {
      tone(SPEAKER, notes[i], times[i]);
      delay(times[i]);
    }
    //W przypadku gdy przycisk nadal jest wciśnięty, mimo że melodyjka już się skończyła,
    //program czeka w tym miejscu, aż przycisk zostanie zwolniony, zanim zacznie wygrywać melodię ponownie.
    while(digitalRead(TRIGGER_PIN));
  }
}
