/*
Odkrywanie świata Arduino, Wydanie drugie
Listing 3.3: Szkic automatycznej lampki nocnej
https://www.exploringarduino.com/content2/ch3

Wszelkie prawa zastrzeżone 2019 Jeremy Blum ( https://www.jeremyblum.com )
Licencja MIT ( https://github.com/sciguy14/Exploring-Arduino-2nd-Edition/blob/master/LICENSE.md )
*/

// Automatyczna lampka nocna

const int WLED=9;        // Biała dioda LED podłączona do pinu 9 (PWM)
const int LIGHT=0;       // Czujnik światła podłączony do analogowego pinu 0
const int MIN_LIGHT=200; // Minimalna oczekiwana wartość światła
const int MAX_LIGHT=900; // Maksymalna oczekiwana wartość światła
int val = 0;             // Zmienna przechowująca odczyty analogowe

void setup()
{
  pinMode(WLED, OUTPUT); // Ustawienie pinu białej diody jako wyjścia
}

void loop()
{
  val = analogRead(LIGHT);                      // Odczytaj wartość z czujnika światła
  val = map(val, MIN_LIGHT, MAX_LIGHT, 255, 0); // Przekształć odczyt z czujnika światła
  val = constrain(val, 0, 255);                 // Ogranicz wartość światła
  analogWrite(WLED, val);                       // Steruj jasnością diody LED
}
