/*
Odkrywanie świata Arduino, Wydanie drugie
Listing 13.3: Maszyna dźwiękowa
https://www.exploringarduino.com/content2/ch13

Wszelkie prawa zastrzeżone 2019 Jeremy Blum ( https://www.jeremyblum.com )
Licencja MIT ( https://github.com/sciguy14/Exploring-Arduino-2nd-Edition/blob/master/LICENSE.md )
*/

//Wykorzystanie przerwań sprzętowych i wywołanych licznikiem do zabawy z dźwiękiem

//Dołączenie biblioteki TimerOne
#include <TimerOne.h>

//Piny przycisku
const int BTN     = 2;  //Wyjście przycisk z ustabilizowanymi stykami podłączone do pinu 2
const int SPEAKER = 12; //Głośnik podłączony do pinu 12

//Nuty
#define NOTE_C 65
#define NOTE_D 73
#define NOTE_E 82
#define NOTE_F 87
#define NOTE_G 98
#define NOTE_A 110
#define NOTE_B 123

//Zmienne ulotne mogące zmieniać swoją wartość podczas przerwania
volatile int key = NOTE_C;
volatile int octave_multiplier = 1;

void setup()
{
  //Rozpoczęcie komunikacji szeregowej
  Serial.begin(9600);
 
  pinMode (SPEAKER, OUTPUT);
  
  //Odwrócony pin więc sprawdzamy wzrastającą krawędź
  attachInterrupt(digitalPinToInterrupt(BTN), changeKey, RISING);
 
  //Konfiguracja przerwania wywołanego przez licznik
  Timer1.initialize(500000);           // Wywołanie co 0,5 sekundy
  Timer1.attachInterrupt(changePitch); //Uruchomienie funkcji "changePitch" podczas każdego przerwania
}

void changeKey()
{
  octave_multiplier = 1;
  if (key == NOTE_C)
    key = NOTE_D;
  else if (key == NOTE_D)
    key = NOTE_E;
  else if (key == NOTE_E)
    key = NOTE_F;
  else if (key == NOTE_F)
    key = NOTE_G;
  else if (key == NOTE_G)
    key = NOTE_A;
  else if (key == NOTE_A)
    key = NOTE_B;
  else if (key == NOTE_B)
    key = NOTE_C;
}

//Funkcja przerwania wywołanego przez licznik
void changePitch()
{
  octave_multiplier = octave_multiplier * 2;
  if (octave_multiplier > 16) octave_multiplier = 1;
  tone(SPEAKER,key*octave_multiplier);
}

void loop()
{
  Serial.print("Nuta: ");
  Serial.print(key);
  Serial.print(" Mnożnik: ");
  Serial.print(octave_multiplier);
  Serial.print(" Częstotliwość: ");
  Serial.println(key*octave_multiplier);
  delay(100);
}
