/*
Odkrywanie świata Arduino, Wydanie drugie
Listing 16.1: Czujnik BTLE
https://www.exploringarduino.com/content2/ch16

Wszelkie prawa zastrzeżone 2019 Jeremy Blum ( https://www.jeremyblum.com )
Licencja MIT ( https://github.com/sciguy14/Exploring-Arduino-2nd-Edition/blob/master/LICENSE.md )
*/

// Wysyłanie danych z czujnika przez BTLE

// Dołączenie biblioteki nRF51 SPI
#include "Adafruit_BluefruitLE_SPI.h"


// Czip nRF51 jest podłączony do pinów SPI mikrokontrolera 32U4. 
// Kiedy tworzymy obiekt BTLE, musimy podać ich numery: CS (8), IRQ (7) i RST (4):

Adafruit_BluefruitLE_SPI btle(8, 7, 4);

// Ustawienie zmiennej na true w celu jednorazowej konfiguracji
// Dzięki temu nastąpi reset  i zmieni się nazwa połączenia.
// Nic się nie stanie jeżeli będzie to wykonywane przy każdym uruchomieniu (pozostaw wartość true).
// Możesz zmienić na false za każdym następnym razem, gdy program będzie wgrywany do modułu.
const bool PERFORM_CONFIGURATION = true; 

// Taka będzie nazwa urządzenie BTLE na Twoim smartfonie
const String BTLE_NAME = "Jeremy's Sensor";

// Potencjometr jest podłączony do pinu A0
const int POT = A0;

// Znajdująca się na płytce dioda LED jest podłączona do pinu 13
const int STATUS_LED = 13;

void setup(void)
{
  // Ustawienie pinu diody LED jako wyjście
  pinMode(STATUS_LED, OUTPUT);
  
  // Będziemy wyświetlać informacje w monitorze portu szeregowego na potrzeby debugowania
  Serial.begin(9600);
  
  // 32U4 ma sprzętowy interfejs USB, więc sprzed poniższych linijek powinieneś usunąć znaczniki komentarza,
  // jeśli chcesz, aby uruchomił się dopiero po otwarciu monitora portu szeregowego.
  // Oznacz poniższą linijkę jako komentarz, jeśli chcesz uruchomić szkic bez otwierania konsoli szeregowej.

  while(!Serial);

  // Połączenie z modułem
  Serial.print(F("Inicjalizacja BTLE..."));
  if (!btle.begin())
  {
    Serial.println("");
    Serial.println(F("Nieudana próba połączenia z chipem nRF51."));
    while(1);
  }
  Serial.println(F("Gotowe!"));

  // Przywróć ustawienia fabryczne czipa BTLE.
  // Możesz zastosować reset w razie jakichkolwiek błędów w programie powodujących, że moduł nie odpowiada.
  // Po przywróceniu ustawień fabrycznych modułu nadawana jest nazwa.

  if (PERFORM_CONFIGURATION)
  {
    // Przywrócenie ustawień domyślnych
    Serial.print(F("Przywracanie ustawień domyślnych..."));
    if (!btle.factoryReset())
    {
      Serial.println("");
      Serial.println(F("Nie udało się przywrócić ustawień domyślnych."));
      while(1);
    }
    Serial.println(F("Gotowe!"));

    // Ustawienie nazwy za pomocą polecenia AT
    Serial.print(F("Nadawanie urządzeniu nazwy ..."));
    btle.print(F("AT+GAPDEVNAME="));
    btle.println(BTLE_NAME);
    if (!btle.waitForOK())
    {
      Serial.println(F("Nadanie nazwy nieudane."));
      while(1);
    }
    btle.reset(); // Restart modułu, aby nowa nazwa weszła w życie
    Serial.println(F("Gotowe!"));
  }
  
  // Przełączenie na tryb danych (z trybu poleceń)
  btle.setMode(BLUEFRUIT_MODE_DATA);
}

void loop(void)
{
  // Poczekaj na połączenie ze smartfonem (jeśli jeszcze nie jest połączony)
  if (!btle.isConnected())
  {
    Serial.print("Czekam na połączenie ze smartfonem...");
    while (!btle.isConnected())
    {
        delay(1000);
    }
    Serial.println("Połączono!");
  }
  
  // Odczytaj wartość potencjometru
  int val = analogRead(POT);

  // Wyświetl odczyt w monitorze portu szeregowego
  Serial.print(F("Wartość analogowa: "));
  Serial.print(val);
  Serial.print(F("\tWysyłanie..."));

  // Wysłanie danych do czipa BTLE, aby zostały wysłane przez połączenie BTLE
  // Po wysłaniu danych, dioda LED zapali się i zgaśnie.
  digitalWrite(STATUS_LED, HIGH);
  btle.println(val);
  
  // Poczekaj aż chip BTLE potwierdzi, że otrzymał dane.
  btle.waitForOK();
  Serial.println(F("OK!"));
  digitalWrite(STATUS_LED, LOW);
}
