/*
Odkrywanie świata Arduino, Wydanie drugie
Listing 12.2: Pasek postępu
https://www.exploringarduino.com/content2/ch12

Wszelkie prawa zastrzeżone 2019 Jeremy Blum ( https://www.jeremyblum.com )
Licencja MIT ( https://github.com/sciguy14/Exploring-Arduino-2nd-Edition/blob/master/LICENSE.md )
*/

//Pasek postępu na wyświetlaczu LCD

//Dołączenie biblioteki LCD
#include <LiquidCrystal.h>

//Inicjalizacja biblioteki z numerami pinów interfejsu
LiquidCrystal lcd(2, 3, 4, 5, 6, 7);

//Stworzenie znaków specjalnych paska postępu
byte p20[8] = {
  B10000,
  B10000,
  B10000,
  B10000,
  B10000,
  B10000,
  B10000,
  B10000,
};
byte p40[8] = {
  B11000,
  B11000,
  B11000,
  B11000,
  B11000,
  B11000,
  B11000,
  B11000,
};
byte p60[8] = {
  B11100,
  B11100,
  B11100,
  B11100,
  B11100,
  B11100,
  B11100,
  B11100,
};
byte p80[8] = {
  B11110,
  B11110,
  B11110,
  B11110,
  B11110,
  B11110,
  B11110,
  B11110,
};
byte p100[8] = {
  B11111,
  B11111,
  B11111,
  B11111,
  B11111,
  B11111,
  B11111,
  B11111,
};

void setup()
{
  //Ustawienie liczby kolumn i wierszy wyświetlacza LCD
  lcd.begin(16, 2);
  //Wyświetlanie wiadomości na ekranie
  lcd.print("Ekran Jeremiego");
 
  //Przypisanie ID znakom specjlanym paska postępu
  lcd.createChar(0, p20);
  lcd.createChar(1, p40);
  lcd.createChar(2, p60);
  lcd.createChar(3, p80);
  lcd.createChar(4, p100);
}

void loop()
{
  //Przesunięcie kursowa do pierwszej kolumny drugiego weirsza
  lcd.setCursor(0,1);
  //Wyszczenie wiersza po jego całkowitym wypełnieniu
  //przez wyświetlenie 16 znaków spacji
  lcd.print("                ");  
 
  //Przejście przez każdy znak w drugim wierszu
  for (int i = 0; i<16; i++)
  {
    //Przejście przez każdą wartość postępu dla każdego znaku
    for (int j=0; j<5; j++)
    {
      lcd.setCursor(i, 1); //Przesunięcie kursora na podaną pozycję
      lcd.write(j);        //Aktualizacja paska postępu
      delay(100);          //Czekanie
    }  
  }
}
