/*
Odkrywanie świata Arduino, Wydanie drugie
Listing 8.3: Kod sterujący myszką dla Leonardo
https://www.exploringarduino.com/content2/ch8

Wszelkie prawa zastrzeżone 2019 Jeremy Blum ( https://www.jeremyblum.com )
Licencja MIT ( https://github.com/sciguy14/Exploring-Arduino-2nd-Edition/blob/master/LICENSE.md )
*/

// Stwórz myszkę!

#include <Mouse.h>

const int LEFT_BUTTON   =4;  //Pin wejściowy dla lewego przycisku
const int MIDDLE_BUTTON =3;  //Pin wejściowy dla środkowego przycisku
const int RIGHT_BUTTON  =2;  //Pin wejściowy dla prawego przycisku
const int X_AXIS        =0;  //Analogowy pin osi x joysticka
const int Y_AXIS        =1;  //Analogowy pin osi y joysticka

void setup()
{
  Mouse.begin();
}

void loop()
{
  int xVal = readJoystick(X_AXIS);         //Odczytaj ruch osi x
  int yVal = readJoystick(Y_AXIS);         //Odczytaj ruch osi y

  Mouse.move(xVal, yVal, 0);               //Poruszaj myszką

  readButton(LEFT_BUTTON, MOUSE_LEFT);     //Sterowanie lewym przyciskiem
  readButton(MIDDLE_BUTTON, MOUSE_MIDDLE); //Sterowanie środkowym przyciskiem
  readButton(RIGHT_BUTTON, MOUSE_RIGHT);   //Sterowanie prawym przyciskiem

  delay(5);                                //Sterowanie responsywnością
}

//Odczytaj wartość joysticka, przeskaluj ją i dodaj martwe pole
int readJoystick(int axis)
{ 
  int val = analogRead(axis);        //Odczytaj wartość analogową
  val = map(val, 0, 1023, -10, 10);  //Przekształć odczyt analogowy

  if (val <= 2 && val >= -2)         //Utwórz martwe pole, aby zapobiec ślizganiu się myszki
    return 0; 
 
  else                               //Zwróć przeskalowaną wartość
    return val;
}

//Odczytaj stan przycisku i zainicjuj polecenie myszki
void readButton(int pin, char mouseCommand)
{
  //Jeśli przycisk jest wciśnięty, zasymuluj kliknięcie jeżeli nie zostało to jeszcze zrobione
  if (digitalRead(pin) == HIGH)
  {
    if (!Mouse.isPressed(mouseCommand))
    {
      Mouse.press(mouseCommand); 
    }
  } 
  //Zwolnij przycisk myszki, jeżeli już został klikniętys
  else
  {
    if (Mouse.isPressed(mouseCommand))
    {
      Mouse.release(mouseCommand); 
    }
  }
}
