/*
Odkrywanie świata Arduino, Wydanie drugie
Listing 5.2: Czujnik odległości o szerokim kącie działania
https://www.exploringarduino.com/content2/ch5

Wszelkie prawa zastrzeżone 2019 Jeremy Blum ( https://www.jeremyblum.com )
Licencja MIT ( https://github.com/sciguy14/Exploring-Arduino-2nd-Edition/blob/master/LICENSE.md )
*/

//Czujnik odległości o szerokim kącie działania
#include <Servo.h>

 const int SERVO  =9;   //Serwomotor podłączony do pinu 9
 const int IR     =0;   //Czujnik odległości IR podłączony do analogowego pinu 0
 const int LED1   =3;   //Wskaźnik diodowy 1
 const int LED2   =5;   //Wskaźnik diodowy 2
 const int LED3   =6;   //Wskaźnik diodowy 3
 const int LED4   =11;  //Wskaźnik diodowy 4

Servo myServo;     //Obiekt Servo
int dist1 = 0;     //Odległość z ćwiartki 1
int dist2 = 0;     //Odległość z ćwiartki 2
int dist3 = 0;     //Odległość z ćwiartki 3
int dist4 = 0;     //Odległość z ćwiartki 4

void setup()
{
    myServo.attach(SERVO); //Dołączenie obiektu Servo
    pinMode(LED1, OUTPUT); //Ustawienie diody LED jako wyjścia
    pinMode(LED2, OUTPUT); //Ustawienie diody LED jako wyjścia
    pinMode(LED3, OUTPUT); //Ustawienie diody LED jako wyjścia
    pinMode(LED4, OUTPUT); //Ustawienie diody LED jako wyjścia
}

void loop()
{
    //Obrót czujnika (4 ćwiartki) i zmiana jasności diody LED
    dist1 = readDistance(15);     //Pomiar odległości, gdy serwomotor jest wychylony pod kątem 15 stopni
    analogWrite(LED1, dist1);     //Zmiana jasności diody
    delay(300);                   //Odczekanie 300 ms przed następnym odczytem
 
    dist2 = readDistance(65);     //Pomiar odległości, gdy serwomotor jest wychylony pod kątem 65 stopni
    analogWrite(LED2, dist2);     //Zmiana jasności diody
    delay(300);                   //Odczekanie 300 ms przed następnym odczytem
 
    dist3 = readDistance(115);    //Pomiar odległości, gdy serwomotor jest wychylony pod kątem 115 stopni
    analogWrite(LED3, dist3);     //Zmiana jasności diody
    delay(300);                   //Odczekanie 300 ms przed następnym odczytem
 
    dist4 = readDistance(165);    //Pomiar odległości, gdy serwomotor jest wychylony pod kątem 165 stopni
    analogWrite(LED4, dist4);     //Zmiana jasności diody
    delay(300);                   //Odczekanie 300 ms przed następnym odczytem
}

int readDistance(int pos)
{
    myServo.write(pos);                //Ustaw w zadanej pozycji
    delay(600);                        //Poczekaj, aż serwomotor się obróci
    int dist = analogRead(IR);         //Odczytaj wartość z czujnika IR
    dist = map(dist, 50, 500, 0, 255); //Zamień odczyt na wartość diody LED
    dist = constrain(dist, 0, 255);    //Ogranicz ją
    return dist;                       //Zwróć przeskalowaną odległość
}
