/*
Odkrywanie świata Arduino, Wydanie drugie
Listing 2.6: Zmiana koloru diody RGB LED lampki nocnej
https://www.exploringarduino.com/content2/ch2

Wszelkie prawa zastrzeżone 2019 Jeremy Blum ( https://www.jeremyblum.com )
Licencja MIT ( https://github.com/sciguy14/Exploring-Arduino-2nd-Edition/blob/master/LICENSE.md )
*/

const int BLED=9;      // Katoda koloru niebieskiego podłączona do pinu 9
const int GLED=10;     // Katoda koloru zielonego podłączona do pinu 10
const int RLED=11;     // Katoda koloru czerwonego podłączona do pinu 11
const int BUTTON=2;    // Przycisk podłączony do pinu 2

boolean lastButton = LOW;    // Poprzedni stan przycisku
boolean currentButton = LOW; // Aktualny stan przycisku
int ledMode = 0;             // Licznik stanu diody LED

void setup()
{
  pinMode (BLED, OUTPUT);   // Ustawienie pinu podłączonego do koloru niebieskiego jako wyjście
  pinMode (GLED, OUTPUT);   // Ustawienie pinu podłączonego do koloru zielonego jako wyjście
  pinMode (RLED, OUTPUT);   // Ustawienie pinu podłączonego do koloru czerwonego jako wyjście
  pinMode (BUTTON, INPUT);  // Ustawienie przycisku jako wejście (niewymagane)
}

/*
* Funkcja odbicia
* Przekaż do niej poprzedni stan przycisku,
* i zwróć aktulany, odbity stan przycisku.
*/
boolean debounce(boolean last)
{
  boolean current = digitalRead(BUTTON);       // Odczytaj stan przycisku
  if (last != current)                         // Jeżeli jest różny od poprzedniego...
  {
    delay(5);                                  // Czekaj 5 ms
    current = digitalRead(BUTTON);             // Odczytaj stan ponownie
  }
  return current;                              // Zwróć aktualny stan przycisku
}

/*
* Lista kolorów diody
* Przekaż do funkcji numer stanu i ustaw odpowiednio kolor diody 
* Z uwagi na fakt, że dioda RGB LED ma wspólną anodę, musisz ustawić
* każdy pin, do którego podłączona jest katoda na LOW, aby dioda zapalił się na zadany kolor.
*/
void setMode(int mode)
{
  //CZERWONY
  if (mode == 1)
  {
    digitalWrite(RLED, LOW);
    digitalWrite(GLED, HIGH);
    digitalWrite(BLED, HIGH);
  }
  //ZIELONY
  else if (mode == 2)
  {
    digitalWrite(RLED, HIGH);
    digitalWrite(GLED, LOW);
    digitalWrite(BLED, HIGH);
  }
  //NIEBIESKI
  else if (mode == 3)
  {
    digitalWrite(RLED, HIGH);
    digitalWrite(GLED, HIGH);
    digitalWrite(BLED, LOW);
  }
  //FIOLETOWY (CZERWONY+NIEBIESKI)
  else if (mode == 4)
  {
    analogWrite(RLED, 127);
    analogWrite(GLED, 255);
    analogWrite(BLED, 127);
  }
  //MORSKI (NIEBIESKI+ZIELONY)
  else if (mode == 5)
  {
    analogWrite(RLED, 255);
    analogWrite(GLED, 127);
    analogWrite(BLED, 127);
  }
  //POMARAŃCZOWY (ZIELONY+CZERWONY)
  else if (mode == 6)
  {
    analogWrite(RLED, 127);
    analogWrite(GLED, 127);
    analogWrite(BLED, 255);
  }
  //BIAŁY (ZIELONY+CZERWONY+NIEBIESKI)
  else if (mode == 7)
  {
    analogWrite(RLED, 170);
    analogWrite(GLED, 170);
    analogWrite(BLED, 170);
  }
  //OFF (mode = 0)
  else
  {
    digitalWrite(RLED, LOW);
    digitalWrite(GLED, LOW);
    digitalWrite(BLED, LOW);
  }
}

void loop()
{
  currentButton = debounce(lastButton);            // Odczytaj stan przycisku
  if (lastButton == LOW && currentButton == HIGH)  // Jeżeli przycisk został naciśnięty...
  {
    ledMode++;                                     // Zwiększ wartość licznika stanu o 1
  }
  lastButton = currentButton;                      // Zresetuj wartość przycisku
  // Jeżeli przeszedłeś już przez wszystki opcje,
  // ustaw licznik na 0.
  if (ledMode == 8) ledMode = 0;
  {
    setMode(ledMode);                               // Zmień stan diody LED
  }
}
