/*
Odkrywanie świata Arduino, Wydanie drugie
Listing 17.6: Wyświetlacz temperatury podłączony do Internetu
https://www.exploringarduino.com/content2/ch17

Wszelkie prawa zastrzeżone 2019 Jeremy Blum ( https://www.jeremyblum.com )
Licencja MIT ( https://github.com/sciguy14/Exploring-Arduino-2nd-Edition/blob/master/LICENSE.md )
*/

// Pobiera na żywo dane dotyczące pogody i wyświetla na dużym 7-segmentowym wyświetlaczu.

#include <SPI.h>
#include <WiFi101.h>
#include <Arduino_JSON.h>
#include <Adafruit_GFX.h>
#include <Adafruit_LEDBackpack.h>

// Informacje o sieci Wi-Fi
const char WIFI_SSID[]     = "TUTAJ UMIEŚĆ NAZWĘ SIECI";      // SSID sieci Wi-Fi
const char WIFI_PASSWORD[] = "TUTAJ UMIEŚĆ HASŁO DO SIECI";  // Hasło do sieci Wi-Fi

// Informacje o API
const char SERVER[] = "api.openweathermap.org";
const char HOST_STRING[] = "HOST: api.openweathermap.org";
const String API_KEY = "TUTAJ WPISZ SWÓJ KLUCZ API";
const String CITY = "San Francisco";  // Zastąp swoim miastem
const String UNITS = "F"; // Ustaw na F lub C

// Informowanie o statusie połączenia za pomocą znajdującej się na płytce diody LED 
const int ONBOARD_LED = 13;

// Utworzenie obiektu wyświetlacza 7-segmentowego
Adafruit_7segment seven_seg_display = Adafruit_7segment();

// Arduino jest klientem.
WiFiClient client;

// Zmienna potrzebna do sprawdzania czy jesteśmy połączeni z punktem dostępowym sieci Wi-Fi
int wifi_status = WL_IDLE_STATUS; 

void setup()
{
  // Ustawienie odpowiednich pinów czipa Wi-Fi
  WiFi.setPins(8,7,4,2);

  // Ustawienie pinów
  pinMode(ONBOARD_LED, OUTPUT);
  digitalWrite(ONBOARD_LED, LOW);

  //  Inicjalizacja wyświetlacza na domyślnym adresie I2C
  seven_seg_display.begin(0x70);

  // Uruchomienie interfejsu szeregowego
  Serial.begin(9600);

  // M0 ma sprzętowy interfejs USB, dlatego poniższa linijka nie powinna być oznaczona jako komentarz,
  // jeśli chcesz, aby program czekał, aż otworzysz monitor portu szeregowego. Oznacz ją jako komentarz, 
  // jeśli chcesz, aby szkic działał bez otwierania konsoli szeregowej (lub gdy moduł jest zasilany baterią).
  // while(!Serial);


  Serial.println("Wyświetlacz temperatury podłączony do Internetu");

  Serial.print("Łączenie z: ");
  Serial.println(WIFI_SSID);
  WiFi.setTimeout(5000);  // Poczekaj 5 s na połączenie.
  while (wifi_status != WL_CONNECTED)
  {
    wifi_status = WiFi.begin(WIFI_SSID, WIFI_PASSWORD);
  }
  Serial.println("Połączono!\n");
  digitalWrite(ONBOARD_LED, HIGH);  // Po połączeniu zapal znajdującą się na płytce diodę LED.
}

void loop()
{
  // Przygotuj zapytanie API.
  String api_units = "metric";
  if (UNITS == "F")
  {
    api_units = "imperial";
  }
  String request = "GET /data/2.5/weather?units=" + 
                   api_units + 
                   "&q=" + 
                   CITY + 
                   "&appid=" + 
                   API_KEY + 
                   " HTTP/1.1";

  // Połącz się z serwerem i wyślij zapytanie.
  if (client.connect(SERVER, 80))
  {
    Serial.println("Wysyłanie żądania: ");
    Serial.println(request);
    Serial.println("");
    client.println(request);
    client.println(HOST_STRING);
    client.println("Połączenie: zamknięte");
    client.println();
  }

  // Poczekaj na odpowiedź.
  while (!client.available());
   
  // Wyrzucaj dane dopóki nie otrzymasz obiektu JSON, który zaczyna się '{'.
  // Wyświetl dane nagłówka, aby łatwiej było odnaleźć ewentualny błąd.
  while(true)
  {
    char h = client.read();
    if (h == '{') break;
    Serial.print(h);
  }

  // Gdy napotkasz na dane w formacie JSON, przekształć je na łańcuch znaków.
  String json = "{";
  do
  {
    char c = client.read();
    json += c;
  } while (client.connected());
  client.stop();
  JSONVar api_object = JSON.parse(json);
  Serial.println("Nieprzetworzony obiekt JSON:");
  Serial.println(api_object);
  double temp = (double) api_object["main"]["temp"];
  Serial.print("Temperatura = ");
  Serial.print(temp);
  Serial.println(UNITS);
  
  // Wyświetl temperaturę.
  int temp_round = constrain(round(temp), -99, 999);
  Serial.print("Wyświetlanie: ");
  Serial.print(temp_round);
  Serial.println(UNITS);

  // Wyświetla dane wyrównując je do prawej, zatem mnożąc je przez 10 przesuwa je o jedną cyfrę w lewo.
  // Dzięki temu jest miejsca na "C" lub "F" po prawej stronie.
  seven_seg_display.print(temp_round*10); 

  // Wyświetla kropkę, która będzie służyć jako znak stopnia.
  seven_seg_display.writeDigitRaw(2, 0x10);  

  // Wyświetla jednostki.
  if (UNITS == "F")
  {
    seven_seg_display.writeDigitRaw(4,0x71);  // Wyświetla "F"
    UNITS = "C"; // Pokazuje inną jednostkę przy kolejnej aktualizacji.
  }
  else
  {
    seven_seg_display.writeDigitRaw(4,0x39);  // Wyświetla "C"
    UNITS = "F"; // Pokazuje inną jednostkę przy kolejnej aktualizacji.
  }

  //  Pokaż na wyświetlaczu.
  seven_seg_display.writeDisplay(); 

  // Poczekaj około minuty przez kolejnym sprawdzeniem temperatury w Internecie.
  Serial.print("Czekanie 1 minutę przed następnym sprawdzeniem.");
  for (int i = 0; i <60; i++)
  {
    Serial.print(".");
    delay(1000); // Opóźnienie 1-sekundowe
  }
  Serial.println("");
  Serial.println("");

}
