/*
Odkrywanie świata Arduino, Wydanie drugie
Listing 17.5: Pobierz temperaturę z Internetu!
https://www.exploringarduino.com/content2/ch17

Wszelkie prawa zastrzeżone 2019 Jeremy Blum ( https://www.jeremyblum.com )
Licencja MIT ( https://github.com/sciguy14/Exploring-Arduino-2nd-Edition/blob/master/LICENSE.md )
*/

// Pobieranie z Internetu aktualizowanych na żywo danych pogodowe

#include <SPI.h>
#include <WiFi101.h>
#include <Arduino_JSON.h>

// Informacje o sieci Wi-Fi
const char WIFI_SSID[]     = "TUTAJ UMIEŚĆ NAZWĘ SIECI";      // SSID sieci Wi-Fi
const char WIFI_PASSWORD[] = "TUTAJ UMIEŚĆ HASŁO DO SIECI";  // Hasło do sieci Wi-Fi

// Informacje o API
const char SERVER[] = "api.openweathermap.org";
const char HOST_STRING[] = "HOST: api.openweathermap.org";
const String API_KEY = "TUTAJ WPISZ SWÓJ KLUCZ API";
const String CITY = "San Francisco";  // Zastąp swoim miastem
const String UNITS = "F"; // Ustaw na F lub C

// Informowanie o statusie połączenia za pomocą znajdującej się na płytce diody LED 
const int ONBOARD_LED = 13;

// Arduino jest klientem.
WiFiClient client;

// Zmienna potrzebna do sprawdzania czy jesteśmy połączeni z punktem dostępu sieci Wi-Fi
int wifi_status = WL_IDLE_STATUS; 

void setup()
{
  // Ustawienie odpowiednich pinów czipa Wi-Fi
  WiFi.setPins(8,7,4,2);

  // Ustawienie pinów
  pinMode(ONBOARD_LED, OUTPUT);
  digitalWrite(ONBOARD_LED, LOW);

  // Uruchomienie interfejsu szeregowego
  Serial.begin(9600);

  // M0 ma sprzętowy interfejs USB, dlatego poniższa linijka nie powinna być oznaczona jako komentarz,
  // jeśli chcesz, aby program czekał, aż otworzysz monitor portu szeregowego. Oznacz ją jako komentarz, 
  // jeśli chcesz, aby szkic działał bez otwierania konsoli szeregowej (lub gdy moduł jest zasilany baterią).

  while(!Serial);

  Serial.println("Pobierzmy temperaturę z WebAPI!");

  Serial.print("Łączenie z: ");
  Serial.println(WIFI_SSID);
  WiFi.setTimeout(5000);  // Poczekaj 5 s na połączenie.
  while (wifi_status != WL_CONNECTED)
  {
    wifi_status = WiFi.begin(WIFI_SSID, WIFI_PASSWORD);
  }
  Serial.println("Połączono!\n");
  digitalWrite(ONBOARD_LED, HIGH);  // Po połączeniu zapal znajdującą się na płytce diodę LED.

  // Przygotuj zapytanie API.
  String api_units = "metric";
  if (UNITS == "F")
  {
    api_units = "imperial";
  }
  String request = "GET /data/2.5/weather?units=" + 
                   api_units + 
                   "&q=" + 
                   CITY + 
                   "&appid=" + 
                   API_KEY + 
                   " HTTP/1.1";

  // Połącz się z serwerem i wyślij zapytanie.
  if (client.connect(SERVER, 80))
  {
    Serial.println("Wysyłanie żądania: ");
    Serial.println(request);
    Serial.println("");
    client.println(request);
    client.println(HOST_STRING);
    client.println("Połączenie: zamknięte");
    client.println();
  }

  // Poczekaj na odpowiedź.
  while (!client.available());
   
  // Wyrzucaj dane dopóki nie otrzymasz obiektu JSON, który zaczyna się '{'.
  // Wyświetl dane nagłówka, aby łatwiej było odnaleźć ewentualny błąd.
  while(true)
  {
    char h = client.read();
    if (h == '{') break;
    Serial.print(h);
  }

  // Gdy napotkasz na dane w formacie JSON, przekształć je na łańcuch znaków.
  String json = "{";
  do
  {
    char c = client.read();
    json += c;
  } while (client.connected());
  client.stop();
  JSONVar api_object = JSON.parse(json);
  Serial.println("Nieprzetworzony obiekt JSON:");
  Serial.println(api_object);
  double temp = (double) api_object["main"]["temp"];
  Serial.print("Temperatura = ");
  Serial.print(temp);
  Serial.println(UNITS);
}

void loop()
{
  // Nic! Dane pobieramy tylko raz w funkcji setup().
}
