/*
Odkrywanie świata Arduino, Wydanie drugie
Listing 17.1: Połącznie w Wi-Fi
https://www.exploringarduino.com/content2/ch17

Wszelkie prawa zastrzeżone 2019 Jeremy Blum ( https://www.jeremyblum.com )
Licencja MIT ( https://github.com/sciguy14/Exploring-Arduino-2nd-Edition/blob/master/LICENSE.md )
*/

// Połączenie modułu M0 z ATWINC1500 z siecią Wi-Fi

#include <SPI.h>
#include <WiFi101.h>

// Informacje o Wi-Fi
const char WIFI_SSID[]     = "TUTAJ UMIEŚĆ NAZWĘ SIECI";      // SSID sieci Wi-Fi
const char WIFI_PASSWORD[] = "TUTAJ UMIEŚĆ HASŁO DO SIECI";  // Hasło do sieci Wi-Fi

// Informowanie o statusie połączenia za pomocą znajdującej się na płytce diody LED 
const int ONBOARD_LED = 13;

// Zmienna potrzebna do sprawdzania czy jesteśmy połączeni z punktem dostępu sieci Wi-Fi
int wifi_status = WL_IDLE_STATUS; 

void setup()
{
  // Ustawienie odpowiednich pinów czipa Wi-Fi
  WiFi.setPins(8,7,4,2);

  // Ustawienie pinów
  pinMode(ONBOARD_LED, OUTPUT);
  digitalWrite(ONBOARD_LED, LOW);

  // Uruchomienie interfejsu szeregowego
  Serial.begin(9600);

  // M0 ma sprzętowy interfejs USB, dlatego poniższa linijka nie powinna być oznaczona jako komentarz,
  // jeśli chcesz, aby program czekał, aż otworzysz monitor portu szeregowego. Oznacz ją jako komentarz, 
  // jeśli chcesz, aby szkic działał bez otwierania konsoli szeregowej (lub gdy moduł jest zasilany baterią).

  while(!Serial);

  Serial.print("Łączenie z: ");
  Serial.println(WIFI_SSID);
  WiFi.setTimeout(5000);  // Poczekaj 5 s na połączenie
  while (wifi_status != WL_CONNECTED)
  {
    wifi_status = WiFi.begin(WIFI_SSID, WIFI_PASSWORD);
  }
  Serial.println("Połączono!\n");
  digitalWrite(ONBOARD_LED, HIGH);  // Po połączeniu zapal znajdującą się na płytce diodę LED 

  // Wyświetl przypisany przez DHCP adres IP
  IPAddress ip = WiFi.localIP();
  Serial.print("Adres IP Arduino to: ");
  Serial.println(ip);
  Serial.println("");
}

void loop()
{
  // Pętla główna nic nie robi
}
