/*
Odkrywanie świata Arduino, Wydanie drugie
Listing 15.3: Lampka zdalnie sterowana
https://www.exploringarduino.com/content2/ch15

Wszelkie prawa zastrzeżone 2019 Jeremy Blum ( https://www.jeremyblum.com )
Licencja MIT ( https://github.com/sciguy14/Exploring-Arduino-2nd-Edition/blob/master/LICENSE.md )
*/

//Zdalne sterowanie lampką

//Program zakłada, że używany jest typ chwilowy modułu odbiornika!
//Typ chwilowy M4 działa tak samo jak przełącznik chwilowy.
//Gdy przycisk jest wciśnięty, pin D2 ma stan wysoki.
//Gdy przycisk nie jest wciśnięty, pin D2 ma stan niski.

#include "pitches.h" //Plik nagłówkowy z definicją dźwięków

//Pin wejścia/wyjścia Arduino jest podłączony do pinu oznaczonego na module jako D2
const int TRIGGER_PIN = 13; //Wejście z modułu radiowego
const int SPEAKER = 9;      //Pin głośnika
const int LAMP = 2;         //Sterowanie lampką

//Tablica dźwięków
int notes[] = {NOTE_E3, NOTE_A4, NOTE_C5};

//Długość każdej nuty (w milisekundach)
int times[] = {250, 250, 250};

//Domyślnie lampka jest wyłączona
bool lamp_on = false;

void setup()
{
  pinMode(LAMP, OUTPUT);       // Ustawienie pinu lampki jako wyjścia
  digitalWrite(LAMP, lamp_on); // Wyłączenie lampki (początkowa wartość tej zmiennej to fałsz) 

}

void loop()
{
  //Po naciśnięciu przycisku, zmień stan lampki
  if (digitalRead(TRIGGER_PIN))
  {
    lamp_on = !lamp_on; //Zmień wartość na przeciwną zmiennej sterującej lampką
    digitalWrite(LAMP, lamp_on); // Ustaw lampkę na nowy stan
    
    //Zagraj inny dźwięk w zależności czy lampka jest zgaszona czy zapalona
    if (lamp_on)
    {
      //Zagraj melodyjkę zapalania lampki
      for (int i = 0; i < 3; i++)
      {
        tone(SPEAKER, notes[i], times[i]);
        delay(times[i]);
      }
    }
    else
    {
      //Zagraj melodyjkę gaszenia lampki (ta sama melodia zagrana od tyłu)
      for (int i = 2; i >= 0; i--)
      {
        tone(SPEAKER, notes[i], times[i]);
        delay(times[i]);
      }
    }
    
    //W przypadku gdy melodia już się skończyła, a przycisk nadal jest wciśnięty, poczekaj w tym miejscu
    while(digitalRead(TRIGGER_PIN));
  }
}
