/*
Odkrywanie świata Arduino, Wydanie drugie
Listing 13.1: Wielozadaniowość - przerwania sprzętowe 
https://www.exploringarduino.com/content2/ch13

Wszelkie prawa zastrzeżone 2019 Jeremy Blum ( https://www.jeremyblum.com )
Licencja MIT ( https://github.com/sciguy14/Exploring-Arduino-2nd-Edition/blob/master/LICENSE.md )
*/

//Wykorzystanie przycisku (z ustabilizowanymi sprzętowo stykami) do sterowania przerwaniem 

//Piny przycisku
const int BTN   = 2;  //Wyjście przycisku podłączone do pinu 2
const int RED   = 11; //Czerwona katoda diody RGB LED podłączona do pinu 11
const int GREEN = 10; //Zielona katoda diody RGB LED podłączona do pinu 10
const int BLUE  = 9;  //Niebieska katoda diody RGB LED podłączona do pinu 9

//Zmienne ulotne mogące zmieniać swoją wartość podczas przerwania
volatile int selectedLED = RED;

void setup()
{
  pinMode(RED, OUTPUT);
  pinMode(GREEN, OUTPUT);
  pinMode(BLUE, OUTPUT);

  //Wyłączenie diody RGB LED na początku programu
  //(Odwrócone stany ponieważ sterujemy katodą)
  digitalWrite(RED, HIGH);
  digitalWrite(BLUE, HIGH);
  digitalWrite(GREEN, HIGH);
    
  //Odwrócony pin więc sprawdzamy wzrastającą krawędź
  attachInterrupt(digitalPinToInterrupt(BTN), swap, RISING);
}

void swap()
{
  //Wyłącznie bieżącego kanału diody RGB LED (wspólna anoda, zatem HIGH oznacza wyłączenie)
  digitalWrite(selectedLED, HIGH);
  //Wybór kolejnego kanału
  if (selectedLED == GREEN)
    selectedLED = RED;
  else if (selectedLED == RED)
    selectedLED = BLUE;
  else if (selectedLED == BLUE)
    selectedLED = GREEN;
}

void loop()
{
  //Rozjaśnianie
  //(Wartości odwrócone ponieważ sterujemy katodą)
  for (int i=255; i>=0; i--)
  {
    analogWrite(selectedLED, i);
    delay(10);
  }
  //Ściemnianie
  //(Wartości odwrócone ponieważ sterujemy katodą)
  for (int i=0; i<=255; i++)
  {
    analogWrite(selectedLED, i);
    delay(10);
  }
  delay(1000);
}
