/*
Odkrywanie świata Arduino, Wydanie drugie
Listing 11.1: Czujnik kierunku bazujący na akcelerometrze
https://www.exploringarduino.com/content2/ch11

Wszelkie prawa zastrzeżone 2019 Jeremy Blum ( https://www.jeremyblum.com )
Licencja MIT ( https://github.com/sciguy14/Exploring-Arduino-2nd-Edition/blob/master/LICENSE.md )
*/

// Wykorzystanie osi Z akcelerometru do określenia kierunku

// Dołączenie bibliotek
// Ta biblioteka już sama w sobie zawiera biblioteki SPI i Universal Sensor Libraries
#include <Adafruit_LIS3DH.h>

// Określenie pinów (piny SPI są używane domyślnie)
const int RED_PIN = 6;
const int GREEN_PIN = 5;
const int CS_PIN = 10;

// Stworzenie obiektu akcelerometru za pomocą sprzętowego interfejsu SPI
Adafruit_LIS3DH accel = Adafruit_LIS3DH(CS_PIN);

void setup()
{
  Serial.begin(9600); // Włączenie portu szeregowego w celu wyświetlania odczytów

  // Połączenie z akcelerometrem
  if (!accel.begin())
  {
    Serial.println("Nie odnaleziono akcelerometru.");
    while (1); // Nieskończona pętla
  }

  // Ustawienie czułości akcelerometru na +/- 2 g
  accel.setRange(LIS3DH_RANGE_2_G);


  // Ustawienie pinów katody diody LED jako wyjścia i ich wyłączenie
  // HIGH wyłącza diodę, gdyż jest to dioda ze wspólną anodą
  pinMode(RED_PIN, OUTPUT);
  digitalWrite(RED_PIN, HIGH);
  pinMode(GREEN_PIN, OUTPUT);
  digitalWrite(GREEN_PIN, HIGH);
}

void loop()
{
  // Odczyt przyspieszenia osi X, Y, Z
  accel.read();

  // Wyświetlanie odczytu osi Z z akcelerometru
  Serial.print("Odczyt z akcelerometru: ");
  Serial.print(accel.z);

  // Wyświetlanie obliczonego rzeczywistego przyspieszenia osi Z na podstawie zakresu +/–2 g 
  Serial.print("\tRzeczywiste przyspieszenie: ");
  Serial.print((float(accel.z)/32768.0)*2.0);
  Serial.println("g");

  // Sprawdzanie czy Arduino jest do góry nogami
  if (accel.z < 0)
  {
    digitalWrite(RED_PIN, LOW);
    digitalWrite(GREEN_PIN, HIGH);
  }
  else
  {
    digitalWrite(RED_PIN, HIGH);
    digitalWrite(GREEN_PIN, LOW);
  }

  // Pobranie nowych danych co 100 ms
  delay(100); 
}
