/*
Odkrywanie świata Arduino, Wydanie drugie
Listing 7.4: Sterowanie pojedynczą diodą LED za pomocą znaków
https://www.exploringarduino.com/content2/ch7

Wszelkie prawa zastrzeżone 2019 Jeremy Blum ( https://www.jeremyblum.com )
Licencja MIT ( https://github.com/sciguy14/Exploring-Arduino-2nd-Edition/blob/master/LICENSE.md )
*/

//Sterowanie diodą LED za pomocą pojedynczego znaku

const int LED=9;

char data; //zmienna przechowująca otrzymane znaki

void setup()
{
  Serial.begin(9600); //Włącz terminal portu szeregowego z przepustowością równą 9600
  pinMode(LED, OUTPUT);
}

void loop()
{
  //Wykonaj działanie tylko wtedy, gdy są dostępne dane w buforze
  if (Serial.available() > 0)
  {
    data = Serial.read(); //Odczytaj 1 bajt
    //Włącz diodę LED
    if (data == '1')
    {
      digitalWrite(LED, HIGH);
      Serial.println("Dioda LED włączona");
    }
    //Wyłącz diodę LED
    else if (data == '0')
    {
      digitalWrite(LED, LOW);
      Serial.println("Dioda LED wyłączona");
    }
  }

}
