/*
Odkrywanie świata Arduino, Wydanie drugie
Listing 7.8: Szkic Processing ustawiający kolory RGB w Arduino
https://www.exploringarduino.com/content2/ch7

Program ten jest darmowy: możesz go dystrybuować i/lub modyfikować
w ramach licencji GNU General Public License v3
opublikowanej przez Free Software Foundation
*/

import processing.serial.*; //Importowanie biblioteki portu szeregowego
PImage img;                 //Obraz	
Serial port;                //Port szeregowy

void setup()
{
  size(640,256); //Rozmiar obrazu HSV
  img = loadImage("hsv.jpg"); //Obraz tła
  port = new Serial(this, "COM7", 9600); //Otwórz port szeregowy
  
}

void draw()
{
  background(0);    //Czarne tło
  image(img,0,0);   //Nałożony obraz
}

void mousePressed() 
{
  color c = get(mouseX, mouseY); //Odczytaj kolor RGB, który kliknięto myszką
  int r = int(map(red(c),   0, 255, 0, 100));
  int g = int(map(green(c), 0, 255, 0, 100));
  int b = int(map(blue(c),  0, 255, 0, 100));
  String colors = r+","+g+","+b+"\n"; //Wyciągnij wartości z koloru
  print(colors); //Wyświetl kolory (kontrolnie)
  port.write(colors); //Wyślij wartości do Arduino
}
