//    Oprogramowanie do automatyki domowej, doczone do ksiki
//    'Projekty Arduino + Android dla Maego Geniusza'
//    Copyright (C) 2011. Simon Monk
//
//    Ten program jest otwartym oprogramowaniem, moesz je rozpowszechnia i modyfikowa
//    zgodnie z warunkami Powszechnej Licencji Publicznej GNU w wersji 3 lub nowszej
//    opublikowanej przez Free Software Foundation 
//
//    Niniejszy program rozpowszechniany jest z nadziej, i bdzie on 
//    uyteczny - jednak BEZ JAKIEJKOLWIEK GWARANCJI, nawet domylnej 
//    gwarancji PRZYDATNOCI HANDLOWEJ albo PRZYDATNOCI DO OKRELONYCH 
//    ZASTOSOWA. W celu uzyskania bliszych informacji patrz Powszechna 
//    Licencja Publiczna GNU. 
//
//    Razem z tym oprogramowaniem powiniene otrzyma kopi Powszechnej
//    Licencji Publicznej GNU. Jeeli nie otrzymae, odwied stron http://www.gnu.org/licenses

package com.simonmonk.home;

import java.util.Date;
import android.content.SharedPreferences;
import android.util.Log;


class HeatingMonitor extends Thread
{
	static final String[] keys = {"0004", "0406", "0607", "0708", "0809", "0912",
		"1215", "1516", "1617", "1722", "2223", "2324"};
	
	private HomeActivity mActivity;
	
	public HeatingMonitor(HomeActivity activity)
	{
		super();
		mActivity = activity;
	}
	
	public void run()
	{
		while (true)
		{
			for (int i = 1; i < 12; i++)
			{
				handleTimeSlot(keys[i]);
			}
			try 
			{
				Thread.sleep(10000); // sprawdzaj co 10 sekund
			} 
			catch (InterruptedException e) 
			{
				e.printStackTrace();
			}
		}
	}
	
	
	private void handleTimeSlot(String key) 
	{
		Date d = new Date();
		String temp;
		int day = d.getDay();
		Log.d("SRM", "d="+day);
		if (day > 0 && day < 6)
		{
		    Log.d("SRM", "dzie roboczy");
			temp = getSetting("TEMP_d" + key);
		}
		else
		{
		    Log.d("SRM", "weekend");
			temp = getSetting("TEMP_w" + key);
		}
		String hourFromS = key.substring(0,2);
		String hourToS = key.substring(2,4);
		int hourFrom = Integer.parseInt(hourFromS);
		int hourTo = Integer.parseInt(hourToS);
		int hour = d.getHours();
		if (hour >= hourFrom && hour < hourTo)
		{
			DigitalOutputs outputs = mActivity.outputs;
			int t = Integer.parseInt(temp);
			if ("C".equals(getSetting("UNITS")))
			{
				t = (t * 9) / 5 + 32;
			}
			t = t + 20; // wspczynnik dopasowujcy - czujnik jest ogrzewany w obudowie
			outputs.setOutput(0x41, t);
		}
	}

	String getSetting(String name)
	{
		SharedPreferences settings = mActivity.getSharedPreferences(PrefsActivity.PREFS_NAME, 0);
        return settings.getString(name, "0");
	}
	  
}
