/**
 * Kod rdowy do ksiki Projekty Arduino + Android dla Maych Geniuszy
 * Copyright 2011 Simon Monk
 *
 * Ten program jest otwartym oprogramowaniem, moesz je rozpowszechnia i modyfikowa
 * zgodnie z warunkami Powszechnej Licencja Publicznej GNU w wersji 2,
 * opublikowanej przez Free Software Foundation (patrz sekcja KOPIOWANIE).
 
 * Niniejszy program rozpowszechniany jest z nadziej, i bdzie on 
 * uyteczny - jednak BEZ JAKIEJKOLWIEK GWARANCJI, nawet domylnej 
 * gwarancji PRZYDATNOCI HANDLOWEJ albo PRZYDATNOCI DO OKRELONYCH 
 * ZASTOSOWA. W celu uzyskania bliszych informacji patrz Powszechna 
 * Licencja Publiczna GNU. 
 */


package org.simonmonk.geiger;

import org.simonmonk.geiger.R;

import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;

public class BaseActivity extends DroidGeigerActivity {

	private InputController mInputController;

	public BaseActivity() {
		super();
	}

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		if (mAccessory != null) {
			showControls();
		} else {
			hideControls();
		}
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		menu.add("Kasuj");
		return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		if (item.getTitle() == "Kasuj") {
			mInputController.clearLog();
		} 
		return true;
	}

	protected void enableControls(boolean enable) {
		if (enable) {
			showControls();
		} else {
			hideControls();
		}
	}

	protected void hideControls() {
		setContentView(R.layout.no_device);
		mInputController = null;
	}

	protected void showControls() {
		setContentView(R.layout.main);

		mInputController = new InputController(this);
		mInputController.accessoryAttached();
	}

	protected void handleGeigerMessage(GeigerMsg t) {
		if (mInputController != null) {
			mInputController.handleGeigerMessage(t.getFlag(), t.getReading());
		}
	}


}