/**
 * Kod rdowy do ksiki Projekty Arduino + Android dla Maych Geniuszy
 * Copyright 2011 Simon Monk
 *
 * Ten program jest otwartym oprogramowaniem, moesz je rozpowszechnia i modyfikowa
 * zgodnie z warunkami Powszechnej Licencja Publicznej GNU w wersji 2,
 * opublikowanej przez Free Software Foundation (patrz sekcja KOPIOWANIE).
 
 * Niniejszy program rozpowszechniany jest z nadziej, i bdzie on 
 * uyteczny - jednak BEZ JAKIEJKOLWIEK GWARANCJI, nawet domylnej 
 * gwarancji PRZYDATNOCI HANDLOWEJ albo PRZYDATNOCI DO OKRELONYCH 
 * ZASTOSOWA. W celu uzyskania bliszych informacji patrz Powszechna 
 * Licencja Publiczna GNU. 
 */

package org.simonmonk.sounddisplay;


import org.cbase.blinkendroid.audio.AudioReader;

import android.util.Log;
import android.widget.CompoundButton;
import android.widget.CompoundButton.OnCheckedChangeListener;
import android.widget.RadioButton;
import android.widget.SeekBar;
import android.widget.SeekBar.OnSeekBarChangeListener;


public class InputController extends AccessoryController implements OnCheckedChangeListener, OnSeekBarChangeListener {

	private AudioReader mAR;
	private RadioButton mCheckboxTest;
	private RadioButton mCheckboxBargraph;
	private RadioButton mCheckboxBeat;
	private SeekBar mGainControl;
	private Visualizer mViz;
	private int mMode = 1; // 1=test, 2=wykres, 3=rytm
	private int mGain = 50;
	

	InputController(DroidSoundDisplayActivity hostActivity) {
		super(hostActivity);
		Log.d("SRM", "konstruktor");
		mHostActivity = hostActivity;
		mCheckboxTest = (RadioButton)findViewById(R.id.radio_test);
		mCheckboxTest.setOnCheckedChangeListener(this);
		mCheckboxBargraph = (RadioButton)findViewById(R.id.radio_bargraph);
		mCheckboxBargraph.setOnCheckedChangeListener(this);
		mCheckboxBeat = (RadioButton)findViewById(R.id.radio_beat);
		mCheckboxBeat.setOnCheckedChangeListener(this);
		mGainControl = (SeekBar)findViewById(R.id.seekbar_gain);
		mGainControl.setOnSeekBarChangeListener(this);

		mViz = new Visualizer();
		AudioReader.Listener listener = new AudioReader.Listener()
		{

			@Override
			public void onReadComplete(short[] buffer) {
				//Log.d("SRM", "" + buffer[0]);
				mViz.updateDisplay(buffer, mHostActivity, mMode, mGain);
			}

		};
		mAR = new AudioReader();
		mAR.startReader(8000, 80, listener);
		Log.d("SRM", "sampler uruchomiony");
	}

	
	protected void onAccesssoryAttached() {
	}


	@Override
	public void onCheckedChanged(CompoundButton button, boolean value) {
		if (button == mCheckboxTest && value) {
			mHostActivity.sendCommand((byte)4, (byte)0, (byte)0); // tryb testowy wczony
			mMode = 1;
		}
		else if (button == mCheckboxBargraph && value) {
			mHostActivity.sendCommand((byte)5, (byte)0, (byte)0); // tryb testowy wyczony
			mMode = 2;
		}
		else if (button == mCheckboxBeat && value) {
			mHostActivity.sendCommand((byte)5, (byte)0, (byte)0); // tryb testowy wyczony
			mMode = 3;
		}
	}


	@Override
	public void onProgressChanged(SeekBar ignore, int value, boolean ignore2) {
		mGain = value;
	}


	@Override
	public void onStartTrackingTouch(SeekBar arg0) {
		// TODO automatycznie wygenerowany kod metody
		
	}


	@Override
	public void onStopTrackingTouch(SeekBar arg0) {
		// TODO automatycznie wygenerowany kod metody
		
	}


}
