//    Oprogramowanie do automatyki domowej, doczone do ksiki
//    'Projekty Arduino + Android dla Maego Geniusza'
//    Copyright (C) 2011. Simon Monk
//
//    Ten program jest otwartym oprogramowaniem, moesz je rozpowszechnia i modyfikowa
//    zgodnie z warunkami Powszechnej Licencji Publicznej GNU w wersji 3 lub nowszej
//    opublikowanej przez Free Software Foundation 
//
//    Niniejszy program rozpowszechniany jest z nadziej, i bdzie on 
//    uyteczny - jednak BEZ JAKIEJKOLWIEK GWARANCJI, nawet domylnej 
//    gwarancji PRZYDATNOCI HANDLOWEJ albo PRZYDATNOCI DO OKRELONYCH 
//    ZASTOSOWA. W celu uzyskania bliszych informacji patrz Powszechna 
//    Licencja Publiczna GNU. 
//
//    Razem z tym oprogramowaniem powiniene otrzyma kopi Powszechnej
//    Licencji Publicznej GNU. Jeeli nie otrzymae, odwied stron http://www.gnu.org/licenses



package com.simonmonk.home;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;


import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.TextView;

public class HomeActivity extends Activity 
{
    /* Metoda wywoywana przy pierwszym tworzeniu aktywnoci */
	
	public DigitalOutputs outputs;
	public String URL = "nie podczony";

	
	private WebServer mWebserver = null;
	private TextView mStatusView;
	
    @Override
    public void onCreate(Bundle savedInstanceState) 
    {
        super.onCreate(savedInstanceState);

        setContentView(R.layout.main);

        URL = startWebServer();
		
		TimerMonitor tm = new TimerMonitor(HomeActivity.this);
		tm.start();
		
		HeatingMonitor hm = new HeatingMonitor(HomeActivity.this);
		hm.start();	
        
		Button button = (Button)findViewById(R.id.openButton);
        button.setOnClickListener(
        		new OnClickListener()
        		{
					public void onClick(View v) 
					{
						Intent myIntent = new Intent(Intent.ACTION_VIEW);
						myIntent.setData(Uri.parse(URL + "home?"));
						startActivity(myIntent);
					}
        		});
        button = (Button)findViewById(R.id.prefsButton);
        button.setOnClickListener(
        		new OnClickListener()
        		{
					public void onClick(View v) 
					{
						Intent i = new Intent(HomeActivity.this, PrefsActivity.class);
			        	startActivity(i);
					}
        		});
        button = (Button)findViewById(R.id.restartButton);
        button.setOnClickListener(
        		new OnClickListener()
        		{
					public void onClick(View v) 
					{
						mWebserver.destroy(); // LE! Ale nie wiem, jak elegancko zrestartowa serwer
					}
        		});
    }

	private String startWebServer() 
	{
		mStatusView = (TextView)findViewById(R.id.statusview);
        URL = "http://" + getLocalIpAddress() + ":8080/";
        outputs = new DigitalOutputs(HomeActivity.this);
       
     	mWebserver = new WebServer(HomeActivity.this);
		mWebserver.start();
		return URL;
	}
    
    public void setStatus(String status)
    {
    	mStatusView.setText(status);
    }
    
    public String getLocalIpAddress() 
    {
    	try 
    	{
    		for (Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces(); en.hasMoreElements();)
    		{
    			NetworkInterface intf = en.nextElement();
    			for (Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses(); enumIpAddr.hasMoreElements();)
    			{
    				InetAddress inetAddress = enumIpAddr.nextElement();
    				if (!inetAddress.isLoopbackAddress()) 
    				{
    					return inetAddress.getHostAddress().toString();
    				}
    			}
    		}
    	} 
    	catch (SocketException ex) 
    	{
    		Log.e("SRM", ex.toString());
    	}
    	return null;
    }

	  
	  
	  
}