package org.simonmonk.arduinoandroid.bot;

import org.simonmonk.arduinodroid.bot.R;
import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.widget.SeekBar;
import android.widget.SeekBar.OnSeekBarChangeListener;
import at.abraxas.amarino.Amarino;

public class DroidDroidControls extends Activity implements OnSeekBarChangeListener {
	
	private static final String TAG = "SM";
	
	
	final int DELAY = 150;
	SeekBar leftSB;
	SeekBar rightSB;
	
	int left = 255;
	int right = 255;
	long lastChange;

	/* Metoda wywoywana przy pierwszym tworzeniu aktywnoci */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.controls);
        
		// pobranie referencji do widokw w pliku ukadu main.xml
        leftSB = (SeekBar) findViewById(R.id.SeekBarLeft);
        rightSB = (SeekBar) findViewById(R.id.SeekBarRight);

        // rejestracja nasuchu
        leftSB.setOnSeekBarChangeListener(this);
        rightSB.setOnSeekBarChangeListener(this);
    }
    
	@Override
	protected void onStart() {
		super.onStart();
        leftSB.setProgress(left);
        rightSB.setProgress(right);      
	}

	@Override
	protected void onStop() {
		super.onStop();
	
		Amarino.disconnect(this, DroidDroid.DEVICE_ADDRESS);
	}



	@Override
	public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
		// nie wysyaj zbyt duo aktualizacji, Arduino nie moe obsuy takiej iloci
		if (System.currentTimeMillis() - lastChange > DELAY ){
			updateState(seekBar);
			lastChange = System.currentTimeMillis();
		}
	}

	@Override
	public void onStartTrackingTouch(SeekBar seekBar) {
		lastChange = System.currentTimeMillis();
	}

	@Override
	public void onStopTrackingTouch(SeekBar seekBar) {
		updateState(seekBar);
	}

	private void updateState(final SeekBar seekBar) {
		
		switch (seekBar.getId()){
			case R.id.SeekBarLeft:
				left = seekBar.getProgress();
				updateLeft();
				break;
			case R.id.SeekBarRight:
				right = seekBar.getProgress();
				updateRight();
				break;
		}
		// odpowied uytkownika
	}
	
	private void updateLeft(){
		Log.d(TAG, "aktualizacja left=" + (512 - left));
		Log.d(TAG, "adres urzdzenia=" + DroidDroid.DEVICE_ADDRESS);
		Amarino.sendDataToArduino(this, DroidDroid.DEVICE_ADDRESS, 'l', (511 - left));
	}
	
	private void updateRight(){
		Log.d(TAG, "aktualizacja right=" + (512 - right));
		Log.d(TAG, "adres urzdzenia=" + DroidDroid.DEVICE_ADDRESS);
		Amarino.sendDataToArduino(this, DroidDroid.DEVICE_ADDRESS, 'r', (511 - right));
	}
	
}