/*
 * Copyright (C) 2011 The Android Open Source Project
 *
 * Licencja Apache, wersja 2.0
 * Uywanie pliku niezgodnie z warunkami licencji zabronione.
 * Licencja jest dostpna pod adresem:
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * O ile nie wymaga tego obowizujce prawo, lub na pimie nie postanowi si inaczej,
 * oprogramowanie objte t licencj jest rozpowszechniane w takim stanie, w jakim jest
 * be adnych gwarancji ani warunkw, ani jawnych, ani domylnych.
 * Szczegowe warunki okrelaj waciwe przepisy i ograniczenia zawarte w tej Licencji
 * 
 */

package org.simonmonk.tv;

import android.content.res.Resources;
import android.view.View;

public abstract class AccessoryController {

	protected DroidTVActivity mHostActivity;

	public AccessoryController(DroidTVActivity activity) {
		mHostActivity = activity;
	}

	protected View findViewById(int id) {
		return mHostActivity.findViewById(id);
	}

	protected Resources getResources() {
		return mHostActivity.getResources();
	}

	void accessoryAttached() {
		onAccesssoryAttached();
	}

	abstract protected void onAccesssoryAttached();

}