#include <string>
#include <string_view>
#include <regex>
#include <assert.h>

std::string transform_date(std::string_view text)
{
   auto rx = std::regex{ R"((\d{1,2})(\.|-|/)(\d{1,2})(\.|-|/)(\d{4}))" };
   return std::regex_replace(text.data(), rx, R"($5-$3-$1)");
}

int main()
{
   setlocale(LC_ALL, "polish");
   using namespace std::string_literals;

   assert(
      transform_date("dzi mamy 11.10.2018!"s) == 
      "dzi mamy 2018-10-11!"s);
}
