#include <string>
#include <sstream>
#include <cctype>
#include <assert.h>
#include <iostream>
#include <wchar.h>


template <class Elem>
using tstring = std::basic_string<Elem, std::char_traits<Elem>, std::allocator<Elem>>;

template <class Elem>
using tstringstream = std::basic_stringstream<Elem, std::char_traits<Elem>, std::allocator<Elem>>;

template <class Elem>
tstring<Elem> capitalize(tstring<Elem> const & text)
{
    tstringstream<Elem> result;

    bool newWord = true;
    for (unsigned char ch : text)
    {
        newWord = newWord || ispunct(ch) || isspace(ch);
        if (isalpha(ch))
        {

            if (newWord)
            {
                result << static_cast<Elem>(toupper(ch));
                newWord = false;
            }
            else
                result << static_cast<Elem>(tolower(ch));
        }
        else result << ch;
    }

    return result.str();
}

int main()
{
    setlocale(LC_ALL, "polish");

    using namespace std::string_literals;

    std::string text = "TO JEST prosty PrzykaD, powinien dZIAA!";
    std::string expected = "To Jest Prosty Przykad, Powinien Dziaa!";

    std::cout << text << std::endl;
    std::cout << expected << std::endl;
    std::cout << capitalize(text) << std::endl;

    assert(expected == capitalize(text));

    assert("Nowoczesne Wyzwania Jzyka C++"s ==
        capitalize("nowoczesne wyzwania jzyka C++"s));

}
