#include <iostream>
#include <cmath>
#include <vector>
#include <iterator>
#include <algorithm>

std::vector<unsigned long long> prime_factors(unsigned long long n)
{
   std::vector<unsigned long long> factors;
   // warto 2, ktra dzieli liczb n
   while (n % 2 == 0)
   {
      factors.push_back(2);
      n = n / 2;
   }

   for (unsigned long long i = 3; i <= std::sqrt(n); i += 2)
   {
      // jeli i dzieli n, wywietl i and podziel n
      while (n%i == 0)
      {
         factors.push_back(i);
         n = n / i;
      }
   }

   // n jest czynnikiem pierwszym wikszym od 2
   if (n > 2)
      factors.push_back(n);

   return factors;
}

int main()
{
   setlocale(LC_ALL, "polish");

   unsigned long long number = 0;
   std::cout << "liczba:";
   std::cin >> number;

   auto factors = prime_factors(number);

   std::copy(
      std::begin(factors), std::end(factors),
      std::ostream_iterator<unsigned long long>(std::cout, " "));
}
