
# coding: utf-8

## Neo4j with Python using Py2Neo

# The IPython Notebook shows example code for working with Neo4j, a graph database, with Python using the Py2Neo package. Other Python APIs are avaialble; see http://neo4j.com/developer/python/ for more options.
# 
# Before running this notebook, install both Neo4j and Py2Neo. Installation instructions are available at:
# 
# http://neo4j.com/download/
# Neo4j installation instructions for multiple platforms
# 
# and
# 
# http://py2neo.org/2.0/
# Install Py2Neo, a Python API for Neo4j
# 
# Start the Neo4j server from the installation direcotry using a command such as 
# 
# ./bin/neo4j console
# 
# See the Neo4j documentation for details.

# In[51]:

import py2neo  # Make Neo4j API available to this script


# Create a connection to the Neo4j serer. 

# Connect to the default database. If the following command generates an error,
# 1. make sure the Neo4j server is running accoording to Neo4j instructions (see http://neo4j.com/download/) and
# 2. the Neo4j server is using the default network port (7474) on the localhost. See Neo4j documentation for more details.

# In[62]:

# set up authentication parameters
# authenticate takes a server, username and password.
# change the authenticate call to use your server, username and password
py2neo.authenticate("localhost:7474", "neo4j", "neo4j!")
graph = py2neo.Graph("http://localhost:7474/db/data/")


# Verify graph is created by displaying graph information

# In[63]:

graph


# Create three nodes to represent three employees

# In[64]:

alice = py2neo.Node("Employee",name="Alice Smith")
bob = py2neo.Node("Employee", name="Bob Washington")
charles = py2neo.Node("Employee", name="Charles Jones")


# Verify each of the three nodes is created correctly

# In[65]:

alice


# In[66]:

bob


# In[67]:

charles


# Create relationships between employees

# In[68]:

alice_mgr_bob = py2neo.Relationship(alice, "MANAGES", bob)
bob_mgr_charles = py2neo.Relationship(bob, "MANAGES", charles)


# In[69]:

alice_mgr_bob


# In[70]:

bob_mgr_charles


# Creating nodes and relationships in py2neo only creates them on the client.
# To create them on the server, call the graph.create methods.

# In[71]:

graph.create(alice)

