package sorting;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import static java.util.Comparator.*;
import static java.util.stream.Collectors.toList;

@SuppressWarnings({"Convert2Lambda", "ComparatorCombinators", "unused", "Java8ListSort"})
public class SortingDemo {
    private List<String> sampleStrings =
            Arrays.asList("to", "jest", "strumie", "acuchw", "tekstowych");

    // domylna sort do Javy 7
    public List<String> alphaSort() {
        Collections.sort(sampleStrings);
        return sampleStrings;
    }

    // domylna sort z Javy 8+
    public List<String> alphaSortUsingStreams() {
        return sampleStrings.stream()
                .sorted()
                .collect(toList());
    }

    // do Javy 7 uycie Comparator z anonimow klas wewntrzn
    public List<String> lengthReverseSortWithComparator() {
        Collections.sort(sampleStrings, new Comparator<String>() {
            @Override
            public int compare(String s1, String s2) {
                return s2.length() - s1.length();
            }
        });
        return sampleStrings;
    }

    // uycie lambdy jako Comparator z lambd
    public List<String> lengthSortWithLambda() {
        Collections.sort(sampleStrings,
                (s1, s2) -> s1.length() - s2.length());
        return sampleStrings;
    }

    // sortowanie wg dugoci za pomoc sorted
    public List<String> lengthSortUsingSorted() {
        return sampleStrings.stream()
                .sorted((s1, s2) -> s1.length() - s2.length())
                .collect(toList());
    }

    // sortowanie wedug dugoci za pomoc comparingInt
    public List<String> lengthSortUsingComparator() {
        return sampleStrings.stream()
                .sorted(comparingInt(String::length))
                .collect(toList());
    }

    // sortowanie wedug dugoci i alfabetycznie
    public List<String> lengthSortThenAlphaSort() {
        Collections.sort(sampleStrings,
                comparingInt(String::length)
                        .thenComparing(naturalOrder()));
        return sampleStrings;
    }

    // sortowanie wedug dugoci i alfabetycznie za pomoc sorted
    public List<String> lengthSortThenAlphaSortUsingSorted() {
        return sampleStrings.stream()
                .sorted(comparingInt(String::length)
                        .thenComparing(naturalOrder()))
                .collect(toList());
    }

    // sortowanie wedug dugoci, potem odwrotnie alfabetycznie za pomoc sorted
    public List<String> lengthSortThenReverseAlphaUsingSorted() {
        return sampleStrings.stream()
                .sorted(comparing(String::length)
                        .thenComparing(reverseOrder()))
                .collect(toList());
    }
}
