import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DeferredExecution {
    private Logger logger = Logger.getLogger(this.getClass().getName());

    private String createExpensiveMessage(String msg) {
        System.out.println("Tworzenie kosztownego komunikatu na poziomie "
                + logger.getLevel());
        return "Ten komunikat to " + msg;
    }

    public void logStuff(String message) {
        logger.info("Ten komunikat to " + message);
        logger.info(() -> "Ten komunikat to " + message);
    }

    public static void main(String[] args) {
        DeferredExecution de = new DeferredExecution();
        de.logger.setLevel(Level.SEVERE);
        de.logStuff("rejestrowanie na poziomie SEVERE");

        de.logger.setLevel(Level.WARNING);
        de.logStuff("rejestrowanie na poziomie WARNING");

        de.logger.setLevel(Level.INFO);
        de.logStuff("rejestrowanie na poziomie INFO");

        de.logger.setLevel(Level.FINE);
        de.logStuff("rejestrowanie na poziomie FINE");

    }
}
