package streams;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class UsingCollect {
    public static void main(String[] args) {
        List<String> strings = Arrays.asList("to", "jest", "strumie", "acuchw", "tekstowych");

        // skutki uboczne --> nie tego chcemy
        List<String> evenLengths = new ArrayList<>();
        strings.stream()
                .filter(s -> s.length() % 2 == 0)
                .forEach(evenLengths::add);
        System.out.println(evenLengths);

        // brak skutkw ubocznych
        List<String> evens = strings.stream()
                .filter(s -> s.length() % 2 == 0)
                .collect(Collectors.toList());
        System.out.println(evens);
    }
}
