package lambdas;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ConsumerDemo {
    public static void main(String[] args) {
        List<Integer> integers = Arrays.asList(3, 1, 4, 1, 5, 9);
        // Anonimowa klasa wewntrzna
        integers.forEach(new Consumer<Integer>() {
            @Override
            public void accept(Integer integer) {
                System.out.println("Warto w anonimowej klasie wewntrznej to " + integer);
            }
        });

        // wyraenie lambda
        integers.forEach(x -> System.out.println("Aktualna warto: " + x));

        // referencja do metody
        integers.forEach(System.out::println);

        Set<Integer> nums = integers.stream()
                .map(n -> n * 2)               // funkcja podwajajca liczby
                .filter(n -> n % 3 == 0)       // predykat zwracajcy tylko wielokrotnoci 3
                .collect(Collectors.toSet());  // konwersja strumienia na zbir
        System.out.println(nums);
    }
}
