package concurrency;

import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;

public class ParallelDemo {

    public static int doubleIt(int n) {
        try {
            Thread.sleep(100);
            System.out.println(Thread.currentThread().getName() + " z n=" + n);
        } catch (InterruptedException ignore) {
        }
        return n * 2;
    }

    @SuppressWarnings("Convert2streamapi")
    public static void main(String[] args) {
        List<Integer> ints = Arrays.asList(3, 1, 4, 1, 5, 9);

        // niefunkcyjne rozwizanie ze wsplnym zmiennym stanem
        int total = 0;
        for (int i : ints) {
            total += i;
        }
        System.out.println("Suma = " + total);

        // uycie strumieni Javy 8
        total = 0; // zmienna lokalna, nie atrybut
//        IntStream.of(3, 1, 4, 1, 5, 9)
//                .forEach(n -> total += n); // niedozwolone; total musi by finalna
//        System.out.println("Suma = " + total);

        total = IntStream.of(3, 1, 4, 1, 5, 9, 2, 6)
                .sum();
        System.out.println("Suma = " + total);

        Instant before = Instant.now();
        total = IntStream.of(3, 1, 4, 1, 5, 9, 2, 6, 5, 3, 5, 7, 9, 7)
                .parallel()
                .map(ParallelDemo::doubleIt)
                .sum();
        Instant after = Instant.now();
        Duration duration = Duration.between(before, after);
        System.out.println("Suma double = " + total);
        System.out.println("Czas = " + duration.toMillis() + " ms");
    }
}
