package streams;

import org.junit.Test;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import static org.junit.Assert.*;

public class StreamTests {
    @Test
    public void ofNullable() throws Exception {
        Stream<String> stream = Stream.ofNullable("abc");
        assertEquals(1, stream.count());

        stream = Stream.ofNullable(null);
        assertEquals(0, stream.count());
    }

    @Test
    public void iterate() throws Exception {
        List<BigDecimal> bigDecimals =
                Stream.iterate(BigDecimal.ZERO, bd -> bd.add(BigDecimal.ONE))
                .limit(10)
                .collect(Collectors.toList());

        assertEquals(10, bigDecimals.size());

        bigDecimals = Stream.iterate(BigDecimal.ZERO,
                bd -> bd.longValue() < 10L,
                bd -> bd.add(BigDecimal.ONE))
                .collect(Collectors.toList());

        assertEquals(10, bigDecimals.size());
    }

    @Test
    public void takeWhile() throws Exception {
        List<String> strings = Stream.of("to jest lista acuchw tekstowych".split(" "))
                .takeWhile(s -> !s.equals("lista"))
                .collect(Collectors.toList());
        List<String> correct = Arrays.asList("to", "jest", "lista", "acuchw");
        assertEquals(correct, strings);
    }

    @Test
    public void dropWhile() throws Exception {
        List<String> strings = Stream.of("to jest lista acuchw tekstowych".split(" "))
                .dropWhile(s -> !s.equals("lista"))
                .collect(Collectors.toList());
        List<String> correct = Arrays.asList("lista", "acuchw");
        assertEquals(correct, strings);
    }

    @Test
    public void takeWhileRandom() throws Exception {
        Random random = new Random();
        List<Integer> nums = random.ints(50, 0, 100)
                .boxed()
                .sorted(Comparator.reverseOrder())
                .takeWhile(n -> n > 90)
                .collect(Collectors.toList());

        System.out.println(nums);
        nums.forEach(n -> assertTrue(n > 70));
    }

    @Test
    public void dropWhileRandom() throws Exception {
        Random random = new Random();
        List<Integer> nums = random.ints(50, 0, 100)
                .sorted()
                .dropWhile(n -> n < 90)
                .boxed()
                .collect(Collectors.toList());

        System.out.println(nums);
        nums.forEach(n -> assertTrue(n > 70));
    }

}
