package streams;

import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class FindFirstAny {
    private static Integer delay(Integer n) {
        try {
            System.out.println(Thread.currentThread().getName());
            Thread.sleep((long) (Math.random() * 100));
        } catch (InterruptedException ignored) {
        }
        return n;
    }

    public static void main(String[] args) {
        // pierwsza liczba parzysta
        Optional<Integer> firstEven = Stream.of(3, 1, 4, 1, 5, 9, 2, 6, 5)
                .filter(n -> n % 2 == 0)
                .findFirst();

        System.out.println(firstEven);

        // findFirst na pustym strumieniu
        Optional<Integer> firstEvenGT10 = Stream.of(3, 1, 4, 1, 5, 9, 2, 6, 5)
                .filter(n -> n > 10)
                .filter(n -> n % 2 == 0)
                .findFirst();

        System.out.println(firstEvenGT10);

        // findFirst rwnolegle (brak rnicy ze wzgldu na kolejno napotykania strumienia)
        firstEven = Stream.of(3, 1, 4, 1, 5, 9, 2, 6, 5)
                .parallel()
                .filter(n -> n % 2 == 0)
                .findFirst();

        System.out.println(firstEven);


        Stream.of(3, 1, 4, 1, 5, 9, 2, 6, 5)
                .unordered()
                .forEach(System.out::println);

        Optional<Integer> any = Stream.of(3, 1, 4, 1, 5, 9, 2, 6, 5)
                .unordered()
                .map(FindFirstAny::delay)
                .findAny();

        System.out.println("Sekwencyjna Any: " + any);

        any = Stream.of(3, 1, 4, 1, 5, 9, 2, 6, 5)
                .unordered()
                .parallel()
                .map(FindFirstAny::delay)
                .findAny();

        System.out.println("Rwnolega Any: " + any);

        Set<String> words = new HashSet<>();
        words.addAll(Arrays.asList("to", "jest", "strumie", "acuchw", "tekstowych"));
        Optional<String> firstString = words.stream()
                .parallel() // w Javie 8 nic nie zmienia
                .findFirst();
        System.out.println("Set rwnolegle: " + firstString);

        List<String> wordList = Arrays.asList("to", "jest", "strumie", "acuchw", "tekstowych");
        words = new HashSet<>();
        words.addAll(wordList);
        firstString = words.stream()
                .findFirst();
        System.out.println(firstString);

        firstString = Stream.of("to", "jest", "strumie", "acuchw", "tekstowych")
                .unordered()
                .findFirst();
        System.out.println(firstString);

        // rekomendacja na podstawie odpowiedzi Stuarta Marksa na pytanie S.O.
        Set<String> words2 = new HashSet<>(words);

        // dodanie i usunicie tylu elementw, aby spowodowa przeliczenie
        IntStream.rangeClosed(0, 50).forEachOrdered(i -> words2.add(String.valueOf(i)));
        words2.retainAll(wordList);

        System.out.println(words.equals(words2));
        System.out.println("Przed: " + words);
        System.out.println("Po: " + words2);

        // Teraz findFirst zwrci inne sowo, poniewa zbir zosta przeliczony.
        //
        // W Javie 9 nowe niezmienne zbiory (i sowniki) s randomizowane, wic
        // ich kolejno iteracji bdzie si zmienia za kadym razem, nawet jeli za kadym razem bd inicjalizowane
        // w taki sam sposb".
    }
}
