package optionals;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class UseDepartment {
    public static void main(String[] args) {
        Manager mrSlate = new Manager("Mr. Slate");

        // dzia z kierownikiem
        Department d = new Department();
        d.setBoss(mrSlate);

        System.out.println("Szef: " + d.getBoss());
        // drukuje: Szef: Optional[Manager{name='Mr. Slate'}]

        // dzia bez kierownika
        Department d1 = new Department();
        System.out.println("Boss: " + d1.getBoss());
        // drukuje: Szef: Optional.empty

        // nie mona wywoa getName na Optional, wic...
        System.out.println("Nazwisko: " +
                d.getBoss().orElse(new Manager("Unknown")).getName());
        // drukuje: Nazwisko: Mr. Slate

        System.out.println("Nazwisko: " +
                d1.getBoss().orElse(new Manager("Nieznane")).getName());
        // drukuje: Nazwisko: Nieznane

        // lub...
        System.out.println("Nazwisko: " + d.getBoss().map(Manager::getName));
        // drukuje: Nazwisko: Optional[Mr. Slate]

        System.out.println("Nazwisko: " + d1.getBoss().map(Manager::getName));
        // drukuje: Nazwisko: Optional.empty

        Company co = new Company();
        co.setDepartment(d);

        System.out.println("Dzia firmy: " + co.getDepartment());
        // drukuje: Dzia firmy: Optional[Department{boss=Manager{name='Mr. Slate'}}]

        System.out.println("Kierownik dziau firmy: " + co.getDepartment()
            .map(Department::getBoss));
        // drukuje: Kierownik dziau firmy: Optional[Optional[Manager{name='Mr. Slate'}]]

        System.out.println(
                co.getDepartment()
                        .flatMap(Department::getBoss)
                        .map(Manager::getName));

        Optional<Company> company = Optional.of(co);

        System.out.println(company
                .flatMap(Company::getDepartment)
                .flatMap(Department::getBoss)
                .map(Manager::getName)
        );

    }
}
