package concurrency;

import java.util.concurrent.*;

public class FutureDemo {
    public static void main(String[] args) {
        ExecutorService service = Executors.newCachedThreadPool();

        @SuppressWarnings("Convert2Lambda")
        Future<String> future = service.submit(new Callable<String>() {
            @Override
            public String call() throws Exception {
                Thread.sleep(100);
                return "Witaj, wiecie!";
            }
        });

        System.out.println("Przetwarzanie...");

        getIfNotCancelled(future);

        future = service.submit(() -> {
            Thread.sleep(10);
            return "Witaj, wiecie!";
        });

        System.out.println("Wicej przetwarzania...");

        while (!future.isDone()) {
            System.out.println("Czekanie...");
        }

        getIfNotCancelled(future);

        future = service.submit(() -> {
            Thread.sleep(10);
            return "Witaj, wiecie!";
        });

        future.cancel(true);

        System.out.println("Jeszcze wicej przetwarzania...");

        getIfNotCancelled(future);

        if (!service.isShutdown())
            service.shutdown();
    }

    private static void getIfNotCancelled(Future<String> future) {
        try {
            if (!future.isCancelled()) {
                System.out.println(future.get());
            } else {
                System.out.println("Anulowano");
            }
        } catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
    }
}
