package functionpackage;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.DoubleSupplier;
import java.util.stream.Collectors;

public class ImplementSupplier {

    public static void main(String[] args) {

        // anonimowa klasa wewntrzna
        @SuppressWarnings({"Convert2Lambda", "UnusedAssignment"})
        DoubleSupplier randomSupplier = new DoubleSupplier() {
            @Override
            public double getAsDouble() {
                return Math.random();
            }
        };

        // wyraenie lambda
        //noinspection Convert2MethodRef,UnusedAssignment
        randomSupplier = () -> Math.random();

        // referencja do metody
        randomSupplier = Math::random;

        System.out.println(randomSupplier.getAsDouble());

        List<String> names = Arrays.asList("Mal", "Wash", "Kaylee", "Inara",
                "Zoë", "Jayne", "Simon", "River", "Shepherd Book");

        Optional<String> first = names.stream()
                .filter(name -> name.startsWith("C"))
                .findFirst();

        System.out.println(first);                      // drukuje Optional.empty
        System.out.println(first.orElse("None")); // drukuje None

        System.out.println(first.orElse(String.format("Nic nie znaleziono w %s",
                names.stream().collect(Collectors.joining(", ")))));

        System.out.println(first.orElseGet(() ->
                String.format("Nic nie znaleziono w %s",
                names.stream().collect(Collectors.joining(", ")))));


    }
}
