package datetime;

import java.time.*;

public class NowFactoryMethod {
    public static void main(String[] args) {
        System.out.println("Instant.now():       " + Instant.now());
        System.out.println("LocalDate.now():     " + LocalDate.now());
        System.out.println("LocalTime.now():     " + LocalTime.now());
        System.out.println("LocalDateTime.now(): " + LocalDateTime.now());
        System.out.println("ZonedDateTime.now(): " + ZonedDateTime.now());

        Clock antarctica = Clock.system(ZoneId.of("Antarctica/South_Pole"));
        System.out.println(ZonedDateTime.now(antarctica));

        // atwiej zaatwi czas na Antarktyce w ten sposb (now() uywa ZoneId bezporednio)
        System.out.println(ZonedDateTime.now(ZoneId.of("Antarctica/South_Pole")));

        // mona utworzy zegar z przesuniciem
        System.out.println(ZonedDateTime.now(
                Clock.offset(antarctica, Duration.ofHours(1))));

        // inne metody fabryczne w Clock
        System.out.println(ZonedDateTime.now(Clock.systemDefaultZone()));
        System.out.println(ZonedDateTime.now(Clock.systemUTC()));

        // zegar, ktry zawsze zwraca ten sam moment
        Clock fixed = Clock.fixed(Instant.now(), ZoneId.of("Antarctica/South_Pole"));
        System.out.println(ZonedDateTime.now(fixed));
        System.out.println(ZonedDateTime.now(fixed));
        System.out.println(ZonedDateTime.now(fixed));
    }
}
