import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class IterableDemo {
    @SuppressWarnings("Convert2MethodRef")
    public static void main(String[] args) {
        List<Integer> nums = Arrays.asList(3, 1, 4, 1, 5, 9);
        // ptla forEach
        for (Integer num : nums) {
            System.out.println(num);
        }

        // wyraenie lambda
        nums.forEach(n -> System.out.println(n));

        // referencja do metody
        nums.forEach(System.out::println);

        Set<Integer> sizes = Stream.of("to", "jest", "lista", "acuchw", "tekstowych")
                .map(String::length)
                .filter(n -> n % 2 == 0)
                .collect(Collectors.toCollection(TreeSet::new));
        System.out.println(sizes.getClass().getName());
        System.out.println("Parzyste dugoci: " + sizes);

        Map<String, Integer> map = Stream.of("to", "jest", "lista", "acuchw", "tekstowych")
                .collect(Collectors.toMap(e -> e, String::length));
        System.out.println(map);

        map.forEach((k,v) -> System.out.println(k + ": " + v));

    }
}
