// login.js
// Skrypt wykorzystuje Ajax do dynamicznej obsługi wysyłki formularza.

// Otocz wszystko natychmiast wykonywaną funkcją:
(function() {
    'use strict';

    // Funkcja używana do wyświetlania komunikatów o błędach:
	function showErrorMessage(message) {
	    var errorDiv = U.$('errorDiv');
	    if (errorDiv) { // Już istnieje, więc uaktualnij.
	        errorDiv.innerHTML = message;
	    } else { // Utwórz i dodaj do strony:
	        errorDiv = document.createElement('div');
	        errorDiv.id = 'errorDiv';
	        errorDiv.innerHTML = message;
	        var loginForm = U.$('loginForm');
	        loginForm.parentNode.insertBefore(errorDiv, loginForm);
	    } // Koniec warunku messageDiv.
	}

    // Funkcja wywoływana w momencie wysyłki formularza.
    // Funkcja waliduje dane z formularza i wykonuje żądanie Ajax.
	function validateForm(e) {

	    // Pobierz obiekt zdarzenia:
	    if (typeof e == 'undefined') e = window.event;

	    // Zapobiegnij wysyłce formularza:
	    if (e.preventDefault) {
	        e.preventDefault();
	    } else {
	        e.returnValue = false;
	    }

        // Pobierz referencje do elementów formularza:
		var username = U.$('username').value;
		var userpass = U.$('userpass').value;

		// Prosta walidacja:
		if ( (username.length > 0) && (userpass.length > 0) ) {

            // Wykonaj żądanie Ajax:
			var ajax = U.getXMLHttpRequestObject();
			ajax.onreadystatechange = function() {

			    // Sprawdź wartość readyState i kod statusu:
			    if (ajax.readyState == 4) {

			        // Sprawdź kod statusu:
			        if ( (ajax.status >= 200 && ajax.status < 300) 
			        || (ajax.status == 304) ) {

                    	// Sprawdź odpowiedź:
						if (ajax.responseText == 'OK') {
                            
							// Ukryj formularz:
							U.$('loginForm').style.visibility = 'hidden';

							// Wyczyść DIV dotyczący błędu, jeśli istnieje:
							var errorDiv = U.$('errorDiv');
							if (errorDiv) {
							    errorDiv.parentNode.removeChild(errorDiv);
							}

							// Wyświetl komunikat o zalogowaniu:
							U.setText('message', 'Jesteś zalogowany!');
							U.$('message').className = 'good';
                            
						} else { // Zła odpowiedź, wyświetl komunikat o błędzie:
						    showErrorMessage('<h2>Błąd!</h2><p class="error">Przekazanie wartości nie odpowiadają zapamiętanym w bazie danych!</p>');
						}

						// Wyczyść obiekt Ajax:
						ajax = null;

			        } else { // Niepoprawny kod statusu, więc wyślij formularz:
			            U.$('loginForm').submit();
			        }
  
			    } // Koniec warunku readyState.

			}; // Koniec funkcji anonimowej onreadystatechange.
        
			// Przeprowadź żądanie:
			ajax.open('POST', 'ajax/login.php', true);
			ajax.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
			var data = 'username=' + encodeURIComponent(username) + '&userpass=' + encodeURIComponent(userpass);
			ajax.send(data);    
    
			} else { // Formularz nie został uzupełniony:

			    // Utwórz komunikat o błędzie:
			    var message = '<h2>Błąd!</h2><p>Proszę poprawić następujące błędy:<ul>';
			    if (username.length == 0) {
			        message += '<li class="error">Zapomniałeś wpisać nazwę użytkownika!</li>'
			    }
			    if (userpass.length == 0) {
			        message += '<li class="error">Zapomniałeś wpisać hasło!</li>'
			    }
			    message += '</ul></p>';
    
			    // Wyświetl błędy w elemencie DIV:
			    showErrorMessage(message);

			} // Koniec warunku dotyczącego walidacji.
    
		    // Zapobiegnij wysłaniu formularza:
		    return false;

		} // Koniec funkcji validateForm().

    // Funkcja wywoływana w momencie wczytania kodu strony WWW.
    // Funkcja dodaje procedurę obsługi wysyłki formularza.
	function init() {
	    U.addEvent(U.$('loginForm'), 'submit', validateForm);
	} // Koniec funkcji init().

	// Przypisz procedurę obsługi zdarzenia wczytania strony WWW:
	U.addEvent(window, 'load', init);

})(); // Koniec funkcji wywoływanej natychmiast.