<?php # view.php
// Strona obsługuje złożenie oferyt przy użyciu technologii Ajax!
// Zwraca JSON.

// Plik konfiguracyjny zawsze musi pojawić się jako pierwszy:
require('../includes/config.inc.php');

// Skrypt zwraca dane w formacie JSON:
header('Content-Type: application/json');

// Domyślna odpowiedź:
$data = array('status' => 'błąd', 'message' => 'Przesłano niepoprawną ofertę.');

// Sprawdź poprawność itemId, ofertę i identyfikatora użytkownika:
if (isset($_GET['itemId']) && filter_var($_GET['itemId'], FILTER_VALIDATE_INT, array('min_range' => 1))) {
	$itemId = $_GET['itemId'];
}
if (isset($_GET['bid']) && filter_var($_GET['bid'], FILTER_VALIDATE_FLOAT) && ($_GET['bid'] > $_GET['currentPrice']) ) {
	$bid = $_GET['bid'];
} 
// Potrzebna jest sesja:
session_start();
if (isset($_SESSION['userId']) && filter_var($_SESSION['userId'], FILTER_VALIDATE_INT, array('min_range' => 1))) {
	$userId = $_SESSION['userId'];
}

if (isset($itemId, $bid, $userId)) { // Dane poprawne:
		
	// Potrzebne jest połączenie z bazą danych:
	require (MYSQL);
		
	// Zapytanie do bazy danych:
	$q = "INSERT INTO bids (itemId, userId, bid, dateSubmitted) VALUES ($itemId, $userId, $bid, UTC_TIMESTAMP())";
	$r = mysqli_query ($dbc, $q) or trigger_error("Zapytanie: $q\n<br />Błąd MySQL: " . mysqli_error($dbc));

	if (@mysqli_affected_rows($dbc) == 1) { // Oferta zaakceptowana.
		$data = array('status' => 'zaakceptowano', 'message' =>  'Oferta wynosząca $' . number_format($bid, 2) . ' została zaakceptowana.');
	} else { // Brak dopasowania?
		$data = array('status' => 'błąd', 'message' => 'Oferta nie została zaakceptowana. Upewnij się, że jest większa od obecnej ceny.');
	}

	mysqli_close($dbc);
	
}// Koniec warunku walidacji.

// Przekaż dane w formacie JSON:
echo json_encode($data);