// os.js
// Skrypt tworzy dwa powiązane ze sobą menu.

// Funkcja wywoływana, gdy zmienia się wartość pierwszego menu.
// Funkcja aktualizuje drugie menu.
function updateMenu() {
    'use strict';
    
    // Pobierz referencje do menu:
	var os = document.getElementById('os');
	var os2 = document.getElementById('os2');

	// Do zapamiętanie opcji:
	var options = null;
       
	// Wyczyść drugie menu:
	while (os2.firstChild) {
		os2.removeChild(os2.firstChild);
	}

    // Określ opcje:
    if (os.value == 'Windows') {
		options = ['7 Home Basic', '7 Home Premium', '7 Professional', '7 Ultimate', 'Vista', 'XP'];
 	} else if (os.value == 'Mac OS X') {
		options = ['10.7 Lion', '10.6 Snow Leopard', '10.5 Leopard', '10.4 Tiger'];
    }

	// Uaktualnij menu:
	if (options) {
		os2.disabled = false;
		
		// Dodaj opcje do menu:
		for (var i = 0, count = options.length; i < count; i++) {
			var opt = document.createElement('option');
			opt.text = opt.value = options[i];
		    os2.appendChild(opt);
		}
		
	} else { // Brak wyboru!
        os2.disabled = true;
	}

} // Koniec funkcji updateMenu().

// Establish functionality on window load:
window.onload = function() {
    'use strict';

    // Pobierz menu wyboru:
	var os = document.getElementById('os');

	// Wyczyść istniejące opcje:
	while (os.firstChild) {
		os.removeChild(os.firstChild);
	}
	
	// Dodaj nowe opcje:
	var options = ['Wybierz', 'Windows', 'Mac OS X'];
	for (var i = 0, count = options.length; i < count; i++) {
		var opt = document.createElement('option');
		opt.text = opt.value = options[i];
	    os.appendChild(opt);
	}
    
    // Dodaj procedurę obsługi:
    os.onchange = updateMenu;
    
    // Utwórz drugie menu wyboru:
	var os2 = document.createElement('select');
	os2.id = 'os2';
	os2.disabled = true;
	os.parentNode.appendChild(os2); 

};