// tests.js
// Skrypt przeprowadza kilka testów na bibliotece narzędziowej z rozdziału 8.

// Zdefiniuj testy:
var myTests = function() {
	'use strict';
	
	// Sprawdź, czy $() zwraca referencję do elementu, gdy podano poprawny identyfikator:
	function testGetElement() {
		jsUnity.assertions.assertNotNull(U.$('output'));
	}
	
	// Sprawdź, czy $() zwraca null, gdy podano niepoprawny identyfikator:
	function testGetInvalidElement() {
		jsUnity.assertions.assertNull(U.$('nieIstnieje'));
	}
	
	// Sprawdź, czy setText() zwraca true, gdy podano poprawny identyfikator:
	function testSetText() {
		jsUnity.assertions.assertTrue(U.setText('output', 'test'));
	}
	
	// Sprawdź, czy setText() zwraca false, gdy podano niepoprawny identyfikator:
	function testCannotSetText() {
		jsUnity.assertions.assertFalse(U.setText('nieIstnieje', 'test'));
	}
	
}; // Koniec funkcji anonimowej myTests.

// Zddefiniuj funkcję wyświetlającą dziennik zdarzeń:
jsUnity.log = function(message) {
	U.$('results').innerHTML += '<p>' + message + '</p>';
};

// Uruchom testy:
jsUnity.run(myTests);