// membership.js
// Ten skrypt wylicza koszt członkostwa.

// Funkcja wywoływana w momencie wysyłania formularza.
// Funkcja wykonuje obliczenia i zwraca wartość false.
function calculate() {

    // Zapewnij korzystanie z trybu ścisłego:
    'use strict';

    // Zmienna przechowująca łączny koszt:
    var cost;

    // Pobierz referencję do pól formularza:
    var type = document.getElementById('type');
    var years = document.getElementById('years');

    // Zamień rok na liczbę:
    if (years && years.value) {
        years = parseInt(years.value, 10);
    }

    // Sprawdź poprawność daty:
   if (type && type.value && years && (years > 0) ) {

        // Oblicz koszt bazowy:
        switch (type.value) {
            case 'basic':
                cost = 10.00;
                break;
            case 'premium':
                cost = 15.00;
                break;
            case 'gold':
                cost = 20.00;
                break;
            case 'platinum':
                cost = 25.00;
                break;
        } // Koniec instrukcji switch.

        // Weź pod uwagę liczbę lat:
        cost *= years;

        // Zastosuj zniżkę dla składni na więcej niż rok:
        if (years > 1) {
            cost *= .80; // 80%
        }

        // Wyświetl łączną kwotę:
        document.getElementById('cost').value = '$' + cost.toFixed(2);

    } else { // Wyświetl błąd:
        document.getElementById('cost').value = 'Proszę wprowadzić poprawne dane.';
    }

    // Zwróć false, by zapobiec wysłaniu formularza:
    return false;

} // Koniec funkcji calculate().

// Konfiguracja początkowa:
function init() {
    'use strict';
    document.getElementById('theForm').onsubmit = calculate;
} // Koniec funkcji init().
window.onload = init;
