<?php # view.php
// Strona wyświetla szczegóły aukcji i umożliwia użytkownikowi zalicytowanie. 

// Plik konfiguracyjny zawsze musi pojawić się jako pierwszy:
require('includes/config.inc.php');

// Ustaw tytuł strony i dodaj nagłówek HTML:
$page_title = 'Szczegóły przedmiotu';
include ('includes/header.html');

// Sprawdź poprawność itemId:
$itemId = false;
if (isset($_GET['itemId']) && filter_var($_GET['itemId'], FILTER_VALIDATE_INT, array('min_range' => 1))) {
	$itemId = $_GET['itemId'];
} elseif (isset($_POST['itemId']) && filter_var($_POST['itemId'], FILTER_VALIDATE_INT, array('min_range' => 1))) { // W przypadku wysyłki formularza.
	$itemId = $_POST['itemId'];
}

// Jeśli itemId nie jest poprawny, wyświetl błąd i zakończ skrypt:
if (!$itemId) {
	echo '<h2>Błąd!</h2><p class="error">Użyto niewłaściwego adresu URL strony!</p>';
	include ('includes/footer.html');
	exit();
}

// Potrzebne jest połączenie z bazą danych:
require(MYSQL);

// Sprawdź, czy wysłano formularz:
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
	
	// Sprawdź identyfikator użytkownika i proponowaną kwotę:
	if (isset($_SESSION['userId']) && filter_var($_SESSION['userId'], FILTER_VALIDATE_INT, array('min_range' => 1))) {
		$userId = $_SESSION['userId'];
	}
	if (isset($_POST['bid']) && filter_var($_POST['bid'], FILTER_VALIDATE_FLOAT) && ($_POST['bid'] > $_POST['currentHidden'])) {
		$bid = $_POST['bid'];
	} 
	
	// Zapamiętaj zalicytowaną kwotę:
	if (isset($userId, $bid)) { // Przekaż dane do bazy danych:
		$q = "INSERT INTO bids (itemId, userId, bid, dateSubmitted) VALUES ($itemId, $userId, $bid, UTC_TIMESTAMP())";
		$r = mysqli_query ($dbc, $q) or trigger_error("Zapytanie: $q\n<br />Błąd MySQL: " . mysqli_error($dbc));
		if (@mysqli_affected_rows($dbc) == 1) {
			echo '<h2>Oferta zaakceptowana!</h2><p class="good">Oferta wynosząca $' . $bid . ' została zaakceptowana.</p>';
		} else {
			echo '<h2>Błąd!</h2><p class="error">Oferta nie została zaakceptowana z powodu błędu w systemie. Przepraszamy.</p>';
		}
	} else { // Wyświetl błąd:
		echo '<h2>Błąd!</h2><p class="error">Oferta nie została zaakceptowana. Upewnij się, że jest większa od aktualnej ceny!</p>';
	}

}

// Pobierz wszystkie oferty...

// Jeśli użytkownik jest zalogowany i wybrał strefę czasową,
// użyj jej do skonwertowania daty i czasu:
if (isset($_SESSION['timezone'])) {
	$closeTz = "CONVERT_TZ(dateClosed, 'UTC', '{$_SESSION['timezone']}')";
	$bidTz = "CONVERT_TZ(dateSubmitted, 'UTC', '{$_SESSION['timezone']}')";
} else {
	$closeTz = 'dateClosed';
	$bidTz = 'dateSubmitted';
}

// Wykonaj żądanie:
$q = "SELECT item, description, openingPrice, COALESCE(MAX(bid), openingPrice), DATE_FORMAT($closeTz,'%Y-%m-%d @ %H:%i'), IF(dateClosed < UTC_TIMESTAMP(), 'closed', 'open'), CEILING((UNIX_TIMESTAMP(dateClosed) - UNIX_TIMESTAMP(UTC_TIMESTAMP()))/60) FROM items LEFT JOIN bids USING (itemId) WHERE items.itemId=$itemId GROUP BY bids.itemId";
$r = mysqli_query ($dbc, $q) or trigger_error("Query: $q\n<br />MySQL Error: " . mysqli_error($dbc));

// Pobierz wiersz:
list ($item, $description, $openingPrice, $currentPrice, $dateClosed, $status, $minutesRemaining) = mysqli_fetch_array($r, MYSQLI_NUM);
mysqli_free_result($r);

// Wyświetl informacje początkowe:
echo "<h1 id=\"itemHeading\">$item</h1>
<p>$description</p>
<h2>Cena początkowa: \$$openingPrice</h2>
<h2 id=\"closingH2\"><em>Data zakończenia</em>: $dateClosed";

// Sprawdź, czy zakończenie nastąpi wkrótce:
if ( ($minutesRemaining < 60) && ($status == 'open')) {
	echo ' <span id="minutesRemainingSpan" class="caution">pozostało tylko ' . $minutesRemaining . ' minut</span>';
}

// Zakończ informacje początkowe:
echo '</h2>';

// Rozpocznij formularz oferty:
if ($status == 'open') {
	
	// Wyświetl nagłówek:
	echo '<h3>Licytuj ten przedmiot</h3>
	<p>Wpisz kwotę wyższą niż $<span id="currentSpan">' .  $currentPrice . '</span>, aby zalicytować przedmiot.</p>';

	// Jeśli użytkownik jest zalogowany, wyświetl formularz:
	if (isset($_SESSION['userId'])) {
		echo '<form action="widok.php" method="post" id="bidForm">
		<label>Oferta</label>
		<input name="bid" id="bid" type="text">
		<br>
		<input class="button" type="submit" value="Licytuj">
		<input type="hidden" name="itemId" id="itemId" value="' . $itemId . '">
		<input type="hidden" name="currentHidden" id="currentHidden" value="' . $currentPrice . '">
	</form>';
	} else { // Użytkownik nie jest zalogowany.
		echo '<p class="caution">Musisz być <a href="logowanie.php">zalogowany</a>, aby licytować.</p>';
	}
	
	// Utwórz kod JavaScript:
	echo '<script>
		var itemId = ' . $itemId . ';
		var currentPrice = ' . $currentPrice . ';
		var minutesRemaining  = ' . $minutesRemaining . ';
	</script>
	<script src="js/view.js"></script>';

} else { // Akcja zakończona!
	echo '<p class="caution">Aukcja została zakończona.</p>
	<h2>Cena końcowa: $' . $currentPrice .'</h2>';
}

// Wyświetl oferty:
// Wykonaj zapytanie:
$q = "SELECT bid, IF($bidTz > DATE_SUB(UTC_TIMESTAMP(), INTERVAL 24 HOUR), DATE_FORMAT($bidTz,'%H:%i'), DATE_FORMAT($bidTz,'%Y-%m-%d @ %H:%i')) FROM bids WHERE itemId=$itemId ORDER BY bids.bid DESC";
$r = mysqli_query ($dbc, $q) or trigger_error("Zapytanie: $q\n<br />Błąd MySQL: " . mysqli_error($dbc));

// Wyświetl nagłówek:
echo "<h3>Aktualne oferty</h3>
<p id=\"refreshMessage\"><a href=\"widok.php?itemId=" . $itemId . "\">Odśwież stronę, by zaktualizować.</a></p>
<table>
	<caption>Wszystkie oferty zgłoszone dla przedmiotu w kolejności malejącej.</caption>
	<thead><tr><th>Oferta</th><th>Data</th></tr></thead>
	<tbody id=\"tableBody\">
";

// Przejdź w pętli przez wyniki i je wyświetl:
while (list ($bid, $bidDate) = mysqli_fetch_array($r, MYSQLI_NUM)) {
	
	// Print the row:
	echo "<tr><td>\$$bid</td><td>$bidDate</td></tr>\n";
		
}

// Czyszczenie:
mysqli_free_result($r);
mysqli_close($dbc);

// Zamknij tabelę:
echo '</tbody>
</table>';

// Dodaj notkę dotyczącą prezentowanych czasów:
if (isset($_SESSION['timezone'])) {
	echo '<p>Wszystkie czasy podawane są w wybranej przez Ciebie strefie czasowej.</p>';
} else {
	echo '<p>Wszystkie czasy podawane są z użyciem czasu uniwersalnego. <a href="logowanie.php">Zaloguj się</a>, aby czasy były podawane w wybranej przez Ciebie strefie czasowej.</p>';
}

// Dołącz stopkę:
include ('includes/footer.html'); 
?>