// Skrypt 4.7 - text.js
// skrypt ogranicza ilość tekstu, jaką można wpisać w obszarze tekstowym.

// Funkcja wywoływana w momencie wysyłania formularza.
// Funkcja ogranicza tekst i zwraca wartość false.
function limitText() {
	'use strict';

	// W celu zapamiętania ograniczonego tekstu:
	var limitedText;

  // Pobierz referencję do wartości formularza:
	var originalText = document.getElementById('comments').value;

	// Znajdź ostatni znak spacji przed setnym znakiem tekstu:
	var lastSpace = originalText.lastIndexOf(' ', 100);

	// Przytnij tekst do tego miejsca:
	limitedText = originalText.slice(0, lastSpace);

	// Wyświetl liczbę znaków z oryginalnego tekstu
	document.getElementById('count').value = originalText.length;

	// Wyświetl tekst po przycięciu:
	document.getElementById('result').value = limitedText;

	// Zwróć wartość false, by nie wysyłać formularza:
	return false;

} // Koniec funkcji calculate().

// Funkcja wykonywana po zakończeniu wczytywania strony WWW.
// Funkcja dodaje procedurę obsługi zdarzenia do formularza.
function init() {
	'use strict';
	document.getElementById('theForm').onsubmit = limitText;
} // Koniec funkcji init().
window.onload = init;
