// tasks.js #4
// Skrypt zarządza listą zadań.

// Funkcja tworząca obiekty Task.
// Funkcja przyjmuje dwa argumenty: nazwę zadania i jego priorytet.
function Task(name, priority) {
    'use strict';
	
	// Przypisz parametry do właściwości:
	this.name = name;
	this.priority = priority;

	// Ustaw właściwosć zakończenia na false (czyli, że zadanie jeszcze trwa).
	this.completed = false;
	
	// Zdefiniuj metodę toString():
	this.toString = function() {
		return this.name + ' (' + this.priority + ')';
	};
	
} // Koniec funkcji Task.

// Funkcja ustawiająca niezbędne zadania:
window.onload = function(){
    'use strict';

	// Referencje do elementów formularza:
	var task = document.getElementById('task');
	var priority = document.getElementById('priority');
	var output = document.getElementById('output');

	// Zmienne przechowujące zadania:
	var tasks = []; 

	// Funkcja wywoływana w momencie wysyłki formularza.
	// Funkcja dodaje zadanie do tablicy.
	document.getElementById('theForm').onsubmit = function() {
		
		// Utwórz nowy obiekt Task:
		var t = new Task(task.value, priority.value);

		// Dodaj go do tablicy:
		tasks.push(t);
		
		// Uaktualnij opis:
        output.innerHTML = 'Obecnie na liście znajduje się <b>' + tasks.length + '</b> zadań. Właśnie dodano:<br>' + t.toString();        

	    // Zwróć false, aby zapobiec wysyłce formularza:
        return false;

	}; // Koniec funkcji anonimowej onsubmit.

}; // Koniec funkcji anonimowej onload.